/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.screen.search;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.config.categories.ItemSearchCategory;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemCompound;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.items.sources.CraftableItemSource;
import codes.cookies.mod.generated.utils.ItemAccessor;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.screen.ScrollbarScreen;
import codes.cookies.mod.screen.search.InspectItemScreen;
import codes.cookies.mod.screen.search.ItemSearchCategories;
import codes.cookies.mod.screen.search.ItemSourceCategories;
import codes.cookies.mod.screen.search.TabConstants;
import codes.cookies.mod.services.IsSameResult;
import codes.cookies.mod.services.item.ItemHighlightService;
import codes.cookies.mod.services.item.ItemSearchService;
import codes.cookies.mod.services.item.ItemServices;
import codes.cookies.mod.services.item.search.ItemSearchFilter;
import codes.cookies.mod.services.item.search.SearchQueryMatcher;
import codes.cookies.mod.utils.RenderUtils;
import codes.cookies.mod.utils.TextUtils;
import codes.cookies.mod.utils.accessors.InventoryScreenAccessor;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.maths.MathUtils;
import codes.cookies.mod.utils.minecraft.SoundUtils;
import com.google.common.base.Predicates;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8001;

public class ItemSearchScreen
extends ScrollbarScreen
implements InventoryScreenAccessor,
TabConstants {
    private static final class_2960 ITEM_SEARCH_BACKGROUND = class_2960.method_60655((String)"cookies-mod", (String)"textures/gui/search.png");
    private static final int ITEM_CELL = 18;
    private static final int ITEM_ROW = 14;
    private static final int BACKGROUND_WIDTH = 281;
    private static final int BACKGROUND_HEIGHT = 185;
    private static final int SCROLLBAR_OFFSET_X = 261;
    private static final int SCROLLBAR_OFFSET_Y = 17;
    private static final int SCROLLBAR_HEIGHT = 163;
    private final List<InventoryScreenAccessor.Disabled> disableds = new ArrayList<InventoryScreenAccessor.Disabled>();
    private final ArrayList<ItemCompound> items = new ArrayList();
    private final List<ItemCompound> finalItems = new ArrayList<ItemCompound>();
    private final class_342 searchField;
    private Map<RepositoryItem, List<ItemCompound>> itemMap = null;
    private int x;
    private int y;
    private static String lastSearch = "";
    private ItemSourceCategories itemSourceCategories = ItemSourceCategories.ALL;
    private ItemSearchCategories itemSearchCategories = ItemSearchCategories.ALL;
    private ItemSearchFilter currentSearch = new SearchQueryMatcher.Builder().build();

    public ItemSearchScreen() {
        super((class_2561)class_2561.method_43471((String)"cookies.screen.item_search"), 163);
        if (!ItemSearchCategory.persistSearch) {
            lastSearch = "";
        }
        this.searchField = new class_342(class_310.method_1551().field_1772, 0, 0, 0, 18, class_2561.method_30163((String)""));
        this.searchField.method_1852(lastSearch);
        this.addAllItems();
    }

    private void addAllItems() {
        this.buildItemIndex();
        this.finalItems.addAll(this.items);
        this.updateMaxScroll();
    }

    private void buildItemIndex() {
        this.items.clear();
        this.itemMap = new HashMap<RepositoryItem, List<ItemCompound>>();
        ItemSources.getItems(this.itemSourceCategories.getSources()).forEach(this::addItem);
        this.items.removeIf(itemCompound -> {
            if (itemCompound.type() != ItemCompound.CompoundType.CRAFTABLE) {
                return false;
            }
            RepositoryItem repositoryItem = (RepositoryItem)itemCompound.itemStack().method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM);
            return this.itemMap.containsKey(repositoryItem) && this.itemMap.get(repositoryItem).size() > 1;
        });
        if (!ItemSearchCategory.enableCraftableItems) {
            this.items.removeIf(itemCompound -> itemCompound.type() == ItemCompound.CompoundType.CRAFTABLE);
        }
        this.itemMap = null;
        this.items.removeIf(Predicate.not(itemCompound -> this.itemSearchCategories.getItemPredicate().test(ItemAccessor.repositoryItemOrNull(itemCompound.itemStack()))));
        this.items.sort(((Comparator)(o1, o2) -> {
            if (o1.type() != ItemCompound.CompoundType.CRAFTABLE || o2.type() != ItemCompound.CompoundType.CRAFTABLE) {
                if (o1.type() == ItemCompound.CompoundType.CRAFTABLE) {
                    return 1;
                }
                if (o2.type() == ItemCompound.CompoundType.CRAFTABLE) {
                    return -1;
                }
                return 0;
            }
            return ((Comparator)(i1, i2) -> {
                Object patt0$temp;
                if (i1.type() == ItemCompound.CompoundType.CRAFTABLE && i2.type() == ItemCompound.CompoundType.CRAFTABLE && (patt0$temp = i1.data()) instanceof CraftableItemSource.Data) {
                    CraftableItemSource.Data d1 = (CraftableItemSource.Data)patt0$temp;
                    Object patt1$temp = i2.data();
                    if (patt1$temp instanceof CraftableItemSource.Data) {
                        CraftableItemSource.Data d2 = (CraftableItemSource.Data)patt1$temp;
                        if (d1.hasAllIngredients() && d2.hasAllIngredients()) {
                            return 0;
                        }
                        if (d1.hasAllIngredients()) {
                            return -1;
                        }
                        if (d2.hasAllIngredients()) {
                            return 1;
                        }
                    }
                }
                return 0;
            }).thenComparing(Comparator.comparingInt(item -> Optional.ofNullable((RepositoryItem)item.itemStack().method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM)).map(RepositoryItem::getTier).map(Enum::ordinal).orElse(0)).reversed()).compare((ItemCompound)o1, (ItemCompound)o2);
        }).thenComparing(Comparator.comparingInt(ItemCompound::amount).reversed()).thenComparing(ItemCompound::name, String::compareToIgnoreCase));
    }

    private void updateMaxScroll() {
        this.updateScroll(Math.max(0, this.finalItems.size() / 14 - 8));
    }

    private void addItem(Item<?> item) {
        RepositoryItem repositoryItem = (RepositoryItem)item.itemStack().method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM);
        List itemCompounds = Optional.ofNullable(this.itemMap.get(repositoryItem)).orElseGet(ArrayList::new);
        if (itemCompounds.isEmpty()) {
            this.itemMap.put(repositoryItem, itemCompounds);
        }
        ItemCompound items = itemCompounds.stream().filter(itemCompound -> ItemServices.isSame(itemCompound.itemStack(), item.itemStack())).findFirst().orElse(new ItemCompound(item));
        itemCompounds.add(items);
        items.add(item);
        this.items.remove(items);
        this.items.add(items);
    }

    @Override
    public int cookies$getBackgroundWidth() {
        return 281;
    }

    @Override
    public int cookies$getBackgroundHeight() {
        return 185;
    }

    @Override
    public int cookies$getX() {
        return this.x;
    }

    @Override
    public int cookies$getY() {
        return this.y;
    }

    @Override
    public List<InventoryScreenAccessor.Disabled> cookies$getDisabled() {
        return this.disableds;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderTopTabs(context, false, mouseX, mouseY);
        this.renderBottomTabs(context, false, mouseX, mouseY);
        context.method_25290(class_1921::method_62277, ITEM_SEARCH_BACKGROUND, this.x, this.y, 0.0f, 0.0f, 281, 185, 281, 185);
        class_5250 text = this.itemSearchCategories != ItemSearchCategories.ALL ? this.itemSourceCategories.getName().method_27661().method_10852((class_2561)class_2561.method_43470((String)" (").method_10852(this.itemSearchCategories.getName()).method_27693(")")) : class_2561.method_43470((String)"Item Search - ").method_10852(this.itemSourceCategories.getName());
        context.method_51439(class_310.method_1551().field_1772, (class_2561)text, this.x + 6, this.y + 6, -11184811, false);
        this.renderScrollbar(context);
        this.drawItems(context, mouseX, mouseY);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        this.renderTopTabs(context, true, mouseX, mouseY);
        this.renderBottomTabs(context, true, mouseX, mouseY);
        context.method_51433(this.field_22793, "?", this.searchField.method_46426() + this.searchField.method_25368() + 5, this.searchField.method_46427(), -11184811, false);
        if (ItemSearchScreen.isInBound(mouseX, mouseY, this.searchField.method_46426() + this.searchField.method_25368() + 3, this.searchField.method_46427() - 1, 10, 10)) {
            context.method_51436(this.method_64506(), this.method_64506().method_1728((class_5348)class_2561.method_43470((String)"\u00a77Search query syntax\n\u00a78\u00a7m      \u00a7r\n\u00a76$: \u00a77Normal search with regex\nA \u00a76!\u00a77 at the start negates the search\n\u00a78\u00a7m      \u00a7r\n\u00a76i\u00a78/\u00a76id\u00a78: \u00a77compares with the \u00a76item id\n\u00a76n\u00a78/\u00a76name\u00a78: \u00a77compares with the \u00a76item name\n\u00a76l\u00a78/\u00a76lore\u00a78: \u00a77compares with the \u00a76item lore\n\u00a76a\u00a78/\u00a76attribute\u00a78: \u00a77checks the \u00a76item \u00a77attributes, you can also use \u00a76(\u00a78<number>\u00a76)\u00a77 at the end to specify attribute level\n\u00a76e\u00a78/\u00a76enchant\u00a78: \u00a77checks the \u00a76item enchants\u00a77, you can also use \u00a76(\u00a78<number>\u00a76)\u00a77 here\n\u00a78\u00a7m      \u00a7r\n\u00a77Individual search operations can have multiple tokens, separate them with a \u00a76,\n\u00a77Search operations can be \u00a76joined \u00a77with a \u00a76&\n\u00a78\u00a7m      \u00a7r\n\u00a77Example: \u00a76a:\u00a7amana\u00a76(\u00a782\u00a76) \u00a77& \u00a7aglowstone\n\u00a77To highlight all items that match the search press \u00a76%s".formatted(CookiesMod.chestSearch.method_16007().getString())), 281), class_8001.field_41687, mouseX, mouseY);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.searchField.field_22763) {
            this.searchField.field_22763 = false;
            this.searchField.method_25365(false);
            return true;
        }
        if (keyCode == 256 && this.searchField.field_22763) {
            this.searchField.field_22763 = false;
            this.searchField.method_25365(false);
            return true;
        }
        if (this.searchField.method_25404(keyCode, scanCode, modifiers) || this.searchField.method_20315()) {
            return true;
        }
        if (CookiesMod.chestSearch.method_1417(keyCode, scanCode)) {
            ItemHighlightService.setActive(this.currentSearch);
            Set<class_2338> collect = this.finalItems.stream().map(ItemServices::extractChestPositions).flatMap(Collection::stream).collect(Collectors.toSet());
            ItemHighlightService.highlightAll(collect);
            return true;
        }
        if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25426() {
        super.method_25426();
        Optional<ProfileData> currentProfile = ProfileStorage.getCurrentProfile();
        if (currentProfile.isEmpty()) {
            this.method_25419();
            CookiesUtils.sendFailedMessage("No currently active profile");
            return;
        }
        this.method_25410(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
        this.searchField.method_1862(true);
        this.searchField.method_1858(false);
        this.searchField.method_1863(this::updateSearch);
        this.searchField.method_25358(90);
        this.searchField.method_53533(12);
        this.searchField.method_1852(lastSearch);
    }

    private void updateSearch(String s) {
        this.finalItems.clear();
        this.finalItems.addAll(this.items);
        lastSearch = s;
        this.finalItems.removeIf(Predicate.not(this.matches(s)));
        this.updateMaxScroll();
        this.scroll = 0;
    }

    private Predicate<? super ItemCompound> matches(String s) {
        SearchQueryMatcher.Builder queryMatcherBuilder = SearchQueryMatcher.parse(s).orElse(null);
        if (queryMatcherBuilder == null) {
            CookiesUtils.sendFailedMessage("Failed to parse search!");
            return Predicates.alwaysTrue();
        }
        SearchQueryMatcher queryMatcher = queryMatcherBuilder.predicate(stack -> ItemServices.getRepositoryItem(stack).map(this.itemSearchCategories.getItemPredicate()::test).orElse(false)).build();
        this.currentSearch = queryMatcher;
        return item -> queryMatcher.doesMatch(item.itemStack()) == IsSameResult.YES;
    }

    public void method_25410(class_310 client, int width, int height) {
        this.x = width / 2 - 140;
        this.y = height / 2 - 92;
        this.searchField.method_48229(this.x + 169, this.y + 6);
        this.updateScrollbar(163, this.x + 261, this.y + 17);
        this.field_22790 = height;
        this.field_22789 = width;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        int offset;
        double localX;
        int slotX;
        double localY;
        int slotY;
        int index;
        if (ItemSearchScreen.isInBound((int)mouseX, (int)mouseY, this.searchField.method_46426() - 3, this.searchField.method_46427(), this.searchField.method_25368(), this.searchField.method_25364()) && button == 0) {
            this.searchField.method_25365(true);
            this.searchField.field_22763 = true;
            return true;
        }
        this.searchField.method_25365(false);
        this.searchField.field_22763 = false;
        if (ItemSearchScreen.isInBound((int)mouseX, (int)mouseY, this.x + 6, this.y + 17, 252, 162) && (index = (slotY = (int)((localY = mouseY - (double)(this.y + 17)) / 18.0)) * 14 + (slotX = (int)((localX = mouseX - (double)(this.x + 6)) / 18.0)) + (offset = 14 * this.scroll)) < this.finalItems.size()) {
            ItemCompound compound = this.finalItems.get(index);
            this.clickedSlot(compound, button);
            return true;
        }
        if (this.mouseClickedTop(mouseX, mouseY) || this.mouseClickedBottom(mouseX, mouseY)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (ItemSearchScreen.isInBound((int)mouseX, (int)mouseY, this.x, this.y, 281, 185)) {
            this.updateScrollbar(verticalAmount);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchField.method_25370() && this.searchField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public void updateInventory() {
        this.buildItemIndex();
        this.updateSearch(lastSearch);
        this.updateMaxScroll();
    }

    private void clickedSlot(ItemCompound compound, int button) {
        if (compound.items().size() == 1 && button == 0) {
            this.handleSingleItemClick(compound);
        } else if (button == 0) {
            this.handleMultiItemClick(compound);
        }
        if (button == 1) {
            CraftableItemSource.Data data;
            Object object = compound.data();
            if (object instanceof CraftableItemSource.Data && !(data = (CraftableItemSource.Data)object).showSupercraftWarning()) {
                return;
            }
            CookiesMod.openScreen(new InspectItemScreen(compound, this));
        }
    }

    private void handleMultiItemClick(ItemCompound compound) {
        if (ItemSearchService.performActions(compound)) {
            this.method_25419();
        }
    }

    private void handleSingleItemClick(ItemCompound compound) {
        if (ItemSearchService.performActions(compound)) {
            this.method_25419();
        }
    }

    private boolean mouseClickedBottom(double mouseX, double mouseY) {
        for (int i = 0; i < ItemSourceCategories.VALUES.length; ++i) {
            if (!ItemSearchScreen.isInBound((int)mouseX, (int)mouseY, this.x + this.getTabX(i), this.y + this.getTabY(false), 27, 32)) continue;
            this.itemSourceCategories = ItemSourceCategories.VALUES[i];
            this.updateInventory();
            SoundUtils.playSound(class_3417.field_14962, 2.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean mouseClickedTop(double mouseX, double mouseY) {
        for (int i = 0; i < ItemSearchCategories.VALUES.length; ++i) {
            if (!ItemSearchScreen.isInBound((int)mouseX, (int)mouseY, this.x + this.getTabX(i), this.y + this.getTabY(true), 27, 32)) continue;
            this.itemSearchCategories = ItemSearchCategories.VALUES[i];
            this.updateInventory();
            SoundUtils.playSound(class_3417.field_14962, 2.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void drawItems(class_332 context, int mouseX, int mouseY) {
        int index = 0;
        int offset = 14 * this.scroll;
        for (int i = 14 * this.scroll; i < this.finalItems.size(); ++i) {
            CraftableItemSource.Data data;
            Object object;
            ItemCompound itemContext = this.finalItems.get(i);
            int slotX = (i - offset) % 14 * 18 + this.x + 7;
            int slotY = (i - offset) / 14 * 18 + this.y + 18;
            context.method_51427(itemContext.itemStack(), slotX, slotY);
            context.method_51448().method_22903();
            context.method_51448().method_22905(0.5f, 0.5f, 1.0f);
            context.method_51448().method_46416(15.0f, 15.0f, 0.0f);
            String format = itemContext.type() == ItemCompound.CompoundType.CRAFTABLE && (object = itemContext.data()) instanceof CraftableItemSource.Data ? ((data = (CraftableItemSource.Data)object).hasAllIngredients() && data.canSupercraft() ? "+" : (data.hasAllIngredients() ? "\u00a7e+" : "\u00a7c+")) : NumberFormat.getCompactNumberInstance(Locale.ENGLISH, NumberFormat.Style.SHORT).format(itemContext.amount());
            context.method_51432(class_310.method_1551().field_1772, itemContext.itemStack(), (int)((float)slotX / 0.5f), (int)((float)slotY / 0.5f), format);
            context.method_51448().method_22909();
            if (mouseX > slotX && mouseY > slotY && mouseX < slotX + 16 && mouseY < slotY + 16) {
                RenderUtils.drawSlotHighlightBack(context, slotX, slotY);
                RenderUtils.drawSlotHighlightFront(context, slotX, slotY);
                List tooltipFromItem = class_437.method_25408((class_310)class_310.method_1551(), (class_1799)itemContext.itemStack());
                this.appendTooltip(tooltipFromItem, itemContext);
                context.method_64038(class_310.method_1551().field_1772, tooltipFromItem, Optional.empty(), mouseX, mouseY);
            }
            if (++index >= 126) break;
        }
    }

    private void renderTopTabs(class_332 context, boolean onlyActive, int mouseX, int mouseY) {
        for (int i = 0; i < ItemSearchCategories.VALUES.length; ++i) {
            boolean isActive;
            ItemSearchCategories value = ItemSearchCategories.VALUES[i];
            boolean bl = isActive = value == this.itemSearchCategories;
            if (onlyActive && !isActive) continue;
            this.renderTab(context, true, isActive, i, value.getDisplay(), value.getName(), mouseX, mouseY);
        }
    }

    private void renderBottomTabs(class_332 context, boolean onlyActive, int mouseX, int mouseY) {
        for (int i = 0; i < ItemSourceCategories.VALUES.length; ++i) {
            boolean isActive;
            ItemSourceCategories value = ItemSourceCategories.VALUES[i];
            boolean bl = isActive = value == this.itemSourceCategories;
            if (onlyActive && !isActive) continue;
            this.renderTab(context, false, isActive, i, value.getDisplay(), value.getName(), mouseX, mouseY);
        }
    }

    private void appendTooltip(List<class_2561> tooltip, ItemCompound itemCompound) {
        CraftableItemSource.Data data;
        tooltip.add((class_2561)class_2561.method_43473());
        int storage = 0;
        int sacks = 0;
        int chests = 0;
        int misc = 0;
        block6: for (Item<?> item : itemCompound.items()) {
            if (!this.itemSourceCategories.has(item.source())) continue;
            switch (item.source()) {
                case STORAGE: {
                    storage += item.amount();
                    continue block6;
                }
                case SACKS: {
                    sacks += item.amount();
                    continue block6;
                }
                case CHESTS: {
                    chests += item.amount();
                    continue block6;
                }
                case CRAFTABLE: {
                    continue block6;
                }
            }
            misc += item.amount();
        }
        int locations = 0;
        if (this.itemSourceCategories.has(ItemSources.STORAGE) && storage > 0) {
            ++locations;
            tooltip.add((class_2561)ItemSources.STORAGE.getName().method_27661().method_27692(class_124.field_1080).method_10852((class_2561)this.formattedText(storage)));
        }
        if (this.itemSourceCategories.has(ItemSources.SACKS) && sacks > 0) {
            ++locations;
            tooltip.add((class_2561)ItemSources.SACKS.getName().method_27661().method_27692(class_124.field_1080).method_10852((class_2561)this.formattedText(sacks)));
        }
        if (this.itemSourceCategories.has(ItemSources.CHESTS) && chests > 0) {
            ++locations;
            tooltip.add((class_2561)ItemSources.CHESTS.getName().method_27661().method_27692(class_124.field_1080).method_10852((class_2561)this.formattedText(chests)));
        }
        if (misc > 0) {
            ++locations;
            tooltip.add((class_2561)class_2561.method_43471((String)"cookies.item_source.misc").method_27692(class_124.field_1080).method_10852((class_2561)this.formattedText(misc)));
        }
        if (this.itemSourceCategories.getSources().length > 1 && locations > 1) {
            tooltip.add((class_2561)TextUtils.translatable("cookies.screen.item_search.total", class_124.field_1080).method_10852((class_2561)this.formattedText(storage + sacks + chests + misc)));
        }
        if (!(itemCompound.data() instanceof CraftableItemSource.Data)) {
            tooltip.add((class_2561)class_2561.method_43473());
        }
        ItemServices.appendMultiTooltip(itemCompound.type(), itemCompound.data(), tooltip);
        Object object = itemCompound.data();
        if (object instanceof CraftableItemSource.Data && !(data = (CraftableItemSource.Data)object).showSupercraftWarning()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.overview").method_27692(class_124.field_1054));
    }

    private void renderTab(class_332 context, boolean top, boolean active, int index, class_1799 itemStack, class_2561 name, int mouseX, int mouseY) {
        class_2960[] identifiers = top ? (active ? TAB_TOP_SELECTED_TEXTURES : TAB_TOP_UNSELECTED_TEXTURES) : (active ? TAB_BOTTOM_SELECTED_TEXTURES : TAB_BOTTOM_UNSELECTED_TEXTURES);
        int tabX = this.x + this.getTabX(index);
        int tabY = this.y + this.getTabY(top);
        context.method_52706(class_1921::method_62277, identifiers[MathUtils.clamp(index, 0, identifiers.length - 1)], tabX, tabY, 26, 32);
        int offset = top ? 1 : -1;
        int itemX = tabX + 5;
        int itemY = tabY + 8 + offset;
        if (ItemSearchScreen.isInBound(mouseX, mouseY, tabX, tabY, 27, 32)) {
            context.method_51438(this.field_22793, name, mouseX, mouseY);
        }
        context.method_51427(itemStack, itemX, itemY);
        context.method_51431(this.field_22793, itemStack, itemX, itemY);
    }

    private class_5250 formattedText(int amount) {
        return class_2561.method_43470((String)": ").method_10852((class_2561)class_2561.method_43470((String)NumberFormat.getIntegerInstance(Locale.ENGLISH).format(amount)).method_27692(class_124.field_1054));
    }

    int getTabX(int index) {
        return index * 27;
    }

    int getTabY(boolean top) {
        return -(top ? 28 : -181);
    }
}

