/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.services.item;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.config.categories.ItemSearchCategory;
import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.profile.IslandChestStorage;
import codes.cookies.mod.events.ChestSaveEvent;
import codes.cookies.mod.events.ItemStackEvents;
import codes.cookies.mod.render.Renderable;
import codes.cookies.mod.render.WorldRender;
import codes.cookies.mod.render.types.BlockHighlight;
import codes.cookies.mod.render.types.CallbackRemovable;
import codes.cookies.mod.services.IsSameResult;
import codes.cookies.mod.services.item.search.ItemSearchFilter;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.types.MiscDataComponentTypes;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class ItemHighlightService {
    @Nullable
    private static ItemHighlight itemHighlight;

    private static void checkChest(class_2338 blockPos, class_2338 second, List<IslandChestStorage.ChestItem> chestItems) {
        ItemHighlightService.getHighlight().ifPresent(highlight -> {
            boolean doesHaveHighlight = chestItems.stream().map(IslandChestStorage.ChestItem::itemStack).map(highlight.filter::doesMatch).anyMatch((Predicate<IsSameResult>)Predicates.not(IsSameResult.NO::equals));
            if (highlight.hasHighlight(blockPos)) {
                if (doesHaveHighlight) {
                    return;
                }
                highlight.getHighlight(blockPos).ifPresent(chestHighlight -> {
                    WorldRender.removeRenderable(chestHighlight.renderable);
                    highlight.chestHighlights.remove(chestHighlight);
                });
            } else {
                if (!doesHaveHighlight) {
                    return;
                }
                ItemHighlightService.highlightChest(blockPos, highlight.filter.getColor());
            }
        });
    }

    private static Optional<ItemHighlight> getHighlight() {
        return Optional.ofNullable(itemHighlight);
    }

    private static Optional<ItemSearchFilter> getFilter() {
        return ItemHighlightService.getHighlight().map(ItemHighlight::filter);
    }

    private static List<class_1799> getModifiedItems() {
        return ItemHighlightService.getHighlight().map(ItemHighlight::modified).orElseGet(ArrayList::new);
    }

    private static Optional<CompletableFuture<Boolean>> getFuture() {
        return ItemHighlightService.getHighlight().map(ItemHighlight::remove);
    }

    public static void modify(class_1799 itemStack) {
        ItemHighlightService.getHighlight().ifPresent(highlight -> {
            if (itemStack.method_57826(MiscDataComponentTypes.ITEM_SEARCH_SERVICE_MODIFIED)) {
                ItemHighlightService.add(itemStack);
                return;
            }
            IsSameResult isSame = highlight.filter.doesMatch(itemStack);
            if (isSame != IsSameResult.NO) {
                Integer i = (Integer)itemStack.method_57824(CookiesDataComponentTypes.ITEM_BACKGROUND_COLOR);
                int saveColor = i == null ? 0 : i;
                int color = highlight.filter.getColor() & 0xFFFFFF;
                itemStack.method_57379(MiscDataComponentTypes.ITEM_SEARCH_SERVICE_MODIFIED, (Object)saveColor);
                itemStack.method_57379(CookiesDataComponentTypes.ITEM_BACKGROUND_COLOR, (Object)((isSame == IsSameResult.YES ? 255 : 102) << 24 | color));
                highlight.modified.add(itemStack);
            }
        });
    }

    public static void setActive(ItemSearchFilter filter) {
        ItemHighlight itemHighlight;
        ItemHighlightService.getHighlight().ifPresent(ItemHighlightService::removeHighlight);
        ItemHighlightService.itemHighlight = itemHighlight = ItemHighlight.createNew(filter);
        CookiesMod.getExecutorService().schedule(() -> ItemHighlightService.removeHighlight(itemHighlight), (long)ItemSearchCategory.highlightTime, TimeUnit.SECONDS);
    }

    private static void removeHighlight(ItemHighlight toRemove) {
        if (itemHighlight == toRemove) {
            itemHighlight = null;
        }
        toRemove.remove.complete(true);
        for (class_1799 modifiedStack : new ArrayList<class_1799>(toRemove.modified)) {
            if (!modifiedStack.method_57826(MiscDataComponentTypes.ITEM_SEARCH_SERVICE_MODIFIED)) continue;
            modifiedStack.method_57381(CookiesDataComponentTypes.ITEM_BACKGROUND_COLOR);
            Integer remove = (Integer)modifiedStack.method_57381(MiscDataComponentTypes.ITEM_SEARCH_SERVICE_MODIFIED);
            if (remove == null || remove == 0) continue;
            modifiedStack.method_57379(CookiesDataComponentTypes.ITEM_BACKGROUND_COLOR, (Object)remove);
        }
    }

    public static void highlightChests(Item<?> item, int color) {
        if (item.source() != ItemSources.CHESTS) {
            return;
        }
        IslandChestStorage.ChestItem data = (IslandChestStorage.ChestItem)item.data();
        ItemHighlightService.highlightChest(data.blockPos(), color);
        data.secondChest().ifPresent(blockPos -> ItemHighlightService.highlightChest(blockPos, color));
    }

    public static void highlightChest(class_2338 blockPos, int color) {
        if (blockPos == null) {
            return;
        }
        ItemHighlightService.getHighlight().ifPresent(itemHighlight -> {
            if (itemHighlight.hasHighlight(blockPos)) {
                return;
            }
            ChestHighlight chestHighlight = new ChestHighlight(blockPos, new CallbackRemovable((Renderable)new BlockHighlight(blockPos, color), itemHighlight.remove));
            itemHighlight.chestHighlights.add(chestHighlight);
            WorldRender.addRenderable(chestHighlight.renderable);
        });
    }

    public static void highlightAll(Set<class_2338> blockPos) {
        if (!LocationUtils.Island.PRIVATE_ISLAND.isActive()) {
            return;
        }
        ItemHighlightService.getFilter().ifPresent(filter -> blockPos.forEach(pos -> ItemHighlightService.highlightChest(pos, filter.getColor())));
    }

    public static void add(class_1799 itemStack) {
        ItemHighlightService.getModifiedItems().add(itemStack);
    }

    static {
        ChestSaveEvent.EVENT.register(ItemHighlightService::checkChest);
        ItemStackEvents.EVENT.register(ItemHighlightService::modify);
    }

    private record ItemHighlight(List<class_1799> modified, CompletableFuture<Boolean> remove, ItemSearchFilter filter, List<ChestHighlight> chestHighlights) {
        public static ItemHighlight createNew(ItemSearchFilter filter) {
            return new ItemHighlight(new ArrayList<class_1799>(), new CompletableFuture<Boolean>(), filter, new ArrayList<ChestHighlight>());
        }

        public boolean hasHighlight(class_2338 blockPos) {
            return this.chestHighlights.stream().map(ChestHighlight::blockPos).anyMatch(arg_0 -> ((class_2338)blockPos).equals(arg_0));
        }

        public Optional<ChestHighlight> getHighlight(class_2338 blockPos) {
            return this.chestHighlights.stream().filter(highlight -> blockPos.equals((Object)highlight.blockPos)).findFirst();
        }
    }

    private record ChestHighlight(class_2338 blockPos, Renderable renderable) {
    }
}

