/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.services.item;

import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemCompound;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.items.sources.CraftableItemSource;
import codes.cookies.mod.data.profile.items.sources.StorageItemSource;
import codes.cookies.mod.data.profile.sub.StorageData;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperManager;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.services.item.ItemHighlightService;
import codes.cookies.mod.services.item.ItemServices;
import codes.cookies.mod.services.item.search.ExactItemMatch;
import codes.cookies.mod.services.item.search.IsSameMatch;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import java.util.function.Predicate;
import net.minecraft.class_2561;

public class ItemSearchService {
    public static void handleCraftable(CraftableItemSource.Data data) {
        if (data.hasAllIngredients()) {
            ItemSearchService.sendCommand("viewrecipe " + data.output().getId());
        } else {
            CraftHelperManager.pushNewCraftHelperItem(data.output().getRepositoryItemNotNull(), 1);
        }
    }

    public static void openStorage(StorageItemSource.Context data) {
        String command = switch (data.location()) {
            default -> throw new MatchException(null, null);
            case StorageData.StorageLocation.BACKPACK -> "bp";
            case StorageData.StorageLocation.ENDER_CHEST -> "ec";
        };
        ItemSearchService.sendCommand(command + " " + (data.page() + 1));
    }

    public static boolean performActions(ItemCompound itemCompound) {
        if (!(LocationUtils.Island.PRIVATE_ISLAND.isActive() || itemCompound.type() != ItemCompound.CompoundType.MULTIPLE && itemCompound.type() != ItemCompound.CompoundType.CHEST)) {
            if (itemCompound.type() == ItemCompound.CompoundType.CHEST) {
                CookiesUtils.sendFailedMessage((class_2561)class_2561.method_43470((String)"You need to be on your island to highlight chests!"));
                return false;
            }
            Item[] array = (Item[])itemCompound.items().stream().filter(Predicate.not(item -> item.source() == ItemSources.CHESTS)).toArray(Item[]::new);
            if (array.length == 0) {
                return false;
            }
            itemCompound = new ItemCompound(array[0]);
            for (int i = 1; i < array.length; ++i) {
                itemCompound.add(array[i]);
            }
        }
        if (itemCompound.type() == ItemCompound.CompoundType.MULTIPLE || itemCompound.type() == ItemCompound.CompoundType.CHEST) {
            ItemHighlightService.setActive(new IsSameMatch(itemCompound.itemStack()));
            ItemHighlightService.highlightAll(ItemServices.extractChestPositions(itemCompound));
            return true;
        }
        return ItemSearchService.performAction(itemCompound.type(), itemCompound.data(), itemCompound.items().iterator().next());
    }

    public static void sendCommand(String command) {
        CookiesUtils.sendCommand(command);
    }

    public static boolean performAction(ItemCompound.CompoundType type, Object data, Item<?> item) {
        if (!LocationUtils.Island.PRIVATE_ISLAND.isActive() && type == ItemCompound.CompoundType.CHEST_POS) {
            CookiesUtils.sendFailedMessage((class_2561)class_2561.method_43470((String)"You need to be on your island to highlight chests!"));
            return false;
        }
        ItemHighlightService.setActive(new ExactItemMatch(item.itemStack()));
        RepositoryItem repositoryItem = (RepositoryItem)item.itemStack().method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM);
        int color = ItemServices.getColor(repositoryItem);
        switch (type) {
            case CHEST_POS: {
                ItemHighlightService.highlightChests(item, color);
                break;
            }
            case STORAGE_PAGE: {
                ItemSearchService.openStorage((StorageItemSource.Context)data);
                break;
            }
            case STORAGE: {
                ItemSearchService.sendCommand("storage");
                break;
            }
            case SACKS: 
            case SACK_OF_SACKS: {
                ItemSearchService.sendCommand("sacks");
                break;
            }
            case ACCESSORIES: {
                ItemSearchService.sendCommand("accessorybag");
                break;
            }
            case POTION_BAG: {
                ItemSearchService.sendCommand("potionbag");
                break;
            }
            case VAULT: {
                ItemSearchService.sendCommand("bank");
                break;
            }
            case CRAFTABLE: {
                ItemSearchService.handleCraftable((CraftableItemSource.Data)data);
                return false;
            }
        }
        return true;
    }
}

