/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.services.item;

import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemCompound;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.items.sources.CraftableItemSource;
import codes.cookies.mod.data.profile.items.sources.StorageItemSource;
import codes.cookies.mod.data.profile.profile.IslandChestStorage;
import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemServices {
    public static boolean isSame(class_1799 first, class_1799 second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.method_7909() != second.method_7909()) {
            return false;
        }
        if (first.method_7909() == class_1802.field_8598 && ItemServices.isSame(first, second, CookiesDataComponentTypes.SKYBLOCK_ID)) {
            return true;
        }
        if (!ItemServices.isSame(first, second, CookiesDataComponentTypes.SKYBLOCK_ID)) {
            return false;
        }
        if (!ItemServices.isSame(first, second, CookiesDataComponentTypes.ENCHANTMENTS)) {
            return false;
        }
        if (!ItemServices.isSame(first, second, CookiesDataComponentTypes.ATTRIBUTES)) {
            return false;
        }
        if (!ItemServices.isSame(first, second, class_9334.field_49631)) {
            return false;
        }
        return ItemServices.isSame(first, second, CookiesDataComponentTypes.MODIFIER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> boolean isSame(class_1799 first, class_1799 second, class_9331<T> type) {
        T firstComponent = ItemUtils.getData(first, type);
        T secondComponent = ItemUtils.getData(second, type);
        if (firstComponent == null || secondComponent == null) {
            if (firstComponent != null) return false;
            if (secondComponent != null) return false;
            return true;
        }
        if (firstComponent instanceof Map) {
            Map firstMap = (Map)firstComponent;
            if (secondComponent instanceof Map) {
                Object firstMapKey;
                Map secondMap = (Map)secondComponent;
                Iterator iterator = firstMap.keySet().iterator();
                do {
                    if (!iterator.hasNext()) return Objects.deepEquals(firstComponent, secondComponent);
                    firstMapKey = iterator.next();
                    if (secondMap.containsKey(firstMapKey)) continue;
                    return false;
                } while (Objects.equals(secondMap.get(firstMapKey), firstMap.get(firstMapKey)));
                return false;
            }
        }
        if (!(firstComponent instanceof class_2561)) return Objects.deepEquals(firstComponent, secondComponent);
        class_2561 firstText = (class_2561)firstComponent;
        if (!(secondComponent instanceof class_2561)) return Objects.deepEquals(firstComponent, secondComponent);
        class_2561 secondText = (class_2561)secondComponent;
        if (firstText.getString() == null) return false;
        if (firstText.getString().equalsIgnoreCase(secondText.getString())) return Objects.deepEquals(firstComponent, secondComponent);
        return false;
    }

    public static void appendMultiTooltip(@Nullable ItemCompound.CompoundType type, Object compoundData, List<class_2561> tooltip) {
        ItemCompound.CompoundType compoundType = type;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CHEST", "CHEST_POS", "SACKS", "STORAGE", "STORAGE_PAGE", "MULTIPLE", "POTION_BAG", "SACK_OF_SACKS", "VAULT", "ACCESSORIES", "CRAFTABLE", "INVENTORY", "FORGE"}, (ItemCompound.CompoundType)compoundType, n)) {
            case 0: {
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.all_chest").method_27692(class_124.field_1054));
                break;
            }
            case 1: {
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.chest").method_27692(class_124.field_1054));
                IslandChestStorage.ChestItem data = (IslandChestStorage.ChestItem)compoundData;
                tooltip.add((class_2561)class_2561.method_43469((String)"cookies.block_xyz", (Object[])new Object[]{data.blockPos().method_10263(), data.blockPos().method_10264(), data.blockPos().method_10260()}).method_27692(class_124.field_1063));
                break;
            }
            case 2: {
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.open_chests").method_27692(class_124.field_1054));
                break;
            }
            case 3: {
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.open_storage").method_27692(class_124.field_1054));
                break;
            }
            case 4: {
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.open_storage_page").method_27692(class_124.field_1054));
                StorageItemSource.Context data = (StorageItemSource.Context)compoundData;
                if (data == null) break;
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.open_storage_page.page").method_10852((class_2561)class_2561.method_43470((String)(": " + (data.page() + 1)))).method_27692(class_124.field_1063));
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.open_storage_page.storage").method_10852((class_2561)class_2561.method_43470((String)": ").method_10852((class_2561)class_2561.method_43471((String)data.location().getTranslationKey()))).method_27692(class_124.field_1063));
                break;
            }
            case 5: {
                if (LocationUtils.Island.PRIVATE_ISLAND.isActive()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight").method_27692(class_124.field_1054));
                    break;
                }
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.no_chests").method_27692(class_124.field_1054));
                break;
            }
            case 6: {
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.potion_bag").method_27692(class_124.field_1054));
                break;
            }
            case 7: {
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.sack_of_sacks").method_27692(class_124.field_1054));
                break;
            }
            case 8: {
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.vault").method_27692(class_124.field_1054));
                break;
            }
            case 9: {
                tooltip.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.click_to_highlight.accessory_bag").method_27692(class_124.field_1054));
                break;
            }
            case 10: {
                ItemServices.addCraftableTooltip(tooltip, compoundData);
                break;
            }
            case 11: {
                tooltip.add((class_2561)class_2561.method_43470((String)"This item is in your inventory!").method_27692(class_124.field_1054));
                break;
            }
            case 12: {
                tooltip.add((class_2561)class_2561.method_43470((String)"This item currently is in the forge!").method_27692(class_124.field_1054));
                break;
            }
            default: {
                tooltip.add((class_2561)class_2561.method_43470((String)("An error occurred :c " + String.valueOf((Object)type))).method_27692(class_124.field_1061));
            }
        }
    }

    public static void addCraftableTooltip(List<class_2561> tooltip, Object compoundData) {
        if (compoundData instanceof CraftableItemSource.Data) {
            CraftableItemSource.Data data = (CraftableItemSource.Data)compoundData;
            if (data.hasAllIngredients() && data.canSupercraft()) {
                tooltip.add((class_2561)class_2561.method_43470((String)"You can craft this item!").method_27692(class_124.field_1077));
            } else if (data.showSupercraftWarning()) {
                tooltip.add((class_2561)class_2561.method_43470((String)"Some items are out of the supercraft reach!").method_27692(class_124.field_1054));
                tooltip.add((class_2561)class_2561.method_43470((String)"(Right-click to find items marked with \u26a0)").method_27692(class_124.field_1063));
            }
            class_5250 bar = class_2561.method_43470((String)"").method_27695(new class_124[]{class_124.field_1055, class_124.field_1080});
            tooltip.add((class_2561)bar);
            int maxWidth = 0;
            for (Map.Entry<Ingredient, CraftableItemSource.IngredientData> entry : data.amounts().entrySet()) {
                CraftableItemSource.IngredientData ingredientData = entry.getValue();
                int amount = ingredientData.available();
                class_5250 text = class_2561.method_43470((String)" ").method_10852((class_2561)entry.getKey().getAsItem().method_7964().method_27661().method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"%s/%s".formatted(Math.min(entry.getKey().getAmount(), amount), entry.getKey().getAmount())))));
                class_5250 append = ingredientData.hasAllItems() ? (ingredientData.canSupercraft() ? class_2561.method_43470((String)"\u2714").method_27692(class_124.field_1060).method_10852((class_2561)text) : class_2561.method_43470((String)"\u26a0").method_27692(class_124.field_1054).method_10852((class_2561)text)) : class_2561.method_43470((String)"\u274c").method_27692(class_124.field_1061).method_10852((class_2561)text);
                maxWidth = Math.max(maxWidth, class_310.method_1551().field_1772.method_27525((class_5348)append));
                tooltip.add((class_2561)append);
            }
            int width = class_310.method_1551().field_1772.method_1727(" ");
            bar.method_27693(StringUtils.repeat((char)' ', (int)(maxWidth / width + 1)));
            tooltip.add((class_2561)bar);
            tooltip.add((class_2561)class_2561.method_43473());
            if (data.hasAllIngredients()) {
                tooltip.add((class_2561)class_2561.method_43470((String)"Left-click to open recipe!").method_27692(class_124.field_1054));
            } else {
                tooltip.add((class_2561)class_2561.method_43470((String)"Left-click to set as craft helper item!").method_27692(class_124.field_1054));
            }
        }
    }

    public static int getColor(RepositoryItem repositoryItem) {
        int color;
        if (repositoryItem != null && repositoryItem.getTier() != null) {
            class_124 formatting = repositoryItem.getTier().getFormatting();
            color = switch (formatting) {
                case class_124.field_1060 -> -8921737;
                case class_124.field_1068 -> -1315861;
                default -> Objects.requireNonNullElse(formatting.method_532(), -38559);
            };
        } else {
            color = -38559;
        }
        return 0xFF000000 | color & 0xFFFFFF;
    }

    public static Set<class_2338> extractChestPositions(ItemCompound itemCompound) {
        HashSet<class_2338> positions = new HashSet<class_2338>();
        for (Item<?> item : itemCompound.items()) {
            if (item.source() != ItemSources.CHESTS) continue;
            IslandChestStorage.ChestItem data = (IslandChestStorage.ChestItem)item.data();
            positions.add(data.blockPos());
            Optional.of(data).flatMap(IslandChestStorage.ChestItem::secondChest).ifPresent(positions::add);
        }
        return positions;
    }

    public static Optional<RepositoryItem> getRepositoryItem(@NotNull class_1799 itemStack) {
        return Optional.ofNullable((RepositoryItem)itemStack.method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM));
    }
}

