/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.services.item.search;

import codes.cookies.mod.config.categories.ItemSearchCategory;
import codes.cookies.mod.services.IsSameResult;
import codes.cookies.mod.services.item.search.ItemSearchFilter;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import com.google.common.base.Predicates;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SearchQueryMatcher
implements ItemSearchFilter {
    private final boolean isRegex;
    private final String searchString;
    private final boolean negate;
    private final List<LevelProperty> attributes;
    private final List<LevelProperty> enchants;
    private final List<String> name;
    private final List<String> id;
    private final List<String> lore;
    private final List<SearchQueryMatcher> children;
    private boolean isRoot = true;
    private final Predicate<class_1799> arbituaryPredicate;

    public static Optional<Builder> parse(String rawQuery) {
        if (rawQuery == null || rawQuery.isEmpty()) {
            return Optional.of(new Builder());
        }
        try {
            String[] split;
            StringReader stringBuffer = new StringReader(rawQuery);
            Builder builder = new Builder();
            if (stringBuffer.peek() == '!') {
                stringBuffer.skip();
                builder.negate();
            }
            if (stringBuffer.canRead(2) && stringBuffer.peek() == '$' && stringBuffer.peek(1) == ':') {
                stringBuffer.skip();
                stringBuffer.skip();
                builder.regex();
            }
            String remaining = stringBuffer.getRemaining();
            builder.search(remaining);
            for (String s : split = remaining.split("&")) {
                SearchQueryMatcher.parseIndividual(s, builder);
            }
            return Optional.of(builder);
        }
        catch (CommandSyntaxException e) {
            return Optional.empty();
        }
    }

    private static void parseIndividual(String queryPart, Builder parent) throws CommandSyntaxException {
        Builder builder = new Builder();
        StringReader part = new StringReader(queryPart.trim());
        if (queryPart.contains(":")) {
            switch (part.readStringUntil(':')) {
                case "i": 
                case "id": {
                    builder.parseString(part.getRemaining(), builder::addId);
                    break;
                }
                case "n": 
                case "name": {
                    builder.parseString(part.getRemaining(), builder::addName);
                    break;
                }
                case "l": 
                case "lore": {
                    builder.parseString(part.getRemaining(), builder::addLore);
                    break;
                }
                case "a": 
                case "attribute": {
                    builder.parseLevelProperty(part.getRemaining(), builder::attribute);
                    break;
                }
                case "e": 
                case "enchants": {
                    builder.parseLevelProperty(part.getRemaining(), builder::enchant);
                    break;
                }
                default: {
                    builder.addName(part.getRemaining());
                    builder.addLore(part.getRemaining());
                }
            }
            parent.append(builder);
            return;
        }
        builder.addName(part.getRemaining());
        builder.addLore(part.getRemaining());
        parent.append(builder);
    }

    @Override
    public int getColor() {
        return 0xFF000000 | ItemSearchCategory.highlightColor & 0xFFFFFF;
    }

    @Override
    public IsSameResult doesMatch(class_1799 stack) {
        boolean result = this.performSearch(stack);
        return IsSameResult.wrapBoolean(this.negate != result);
    }

    private boolean performSearch(class_1799 stack) {
        if (!this.arbituaryPredicate.test(stack)) {
            return false;
        }
        if ((this.searchString == null || this.searchString.isEmpty()) && this.isRoot) {
            return true;
        }
        if (this.isRegex) {
            if (this.searchString == null || this.searchString.isEmpty()) {
                return true;
            }
            HashSet<String> set = new HashSet<String>();
            set.add(stack.method_7964().getString().toLowerCase(Locale.ROOT));
            class_9290 loreComponent = (class_9290)stack.method_57824(class_9334.field_49632);
            if (loreComponent != null) {
                for (class_2561 line : loreComponent.comp_2400()) {
                    set.add(line.getString());
                }
            }
            for (String s : set) {
                if (!s.matches(this.searchString)) continue;
                return true;
            }
            return false;
        }
        if (!this.children.isEmpty()) {
            boolean doesMatch = true;
            for (SearchQueryMatcher child : this.children) {
                doesMatch = doesMatch && child.performSearch(stack);
            }
            if (doesMatch) {
                return true;
            }
        }
        if (Optional.of(stack).map(class_1799::method_7964).map(class_2561::getString).flatMap(this::sanitize).map(this::checkName).orElse(false).booleanValue()) {
            return true;
        }
        if (this.retrieve(stack, class_9334.field_49632).map(class_9290::comp_2400).orElseGet(Collections::emptyList).stream().map(class_2561::getString).map(this::sanitize).filter(Optional::isPresent).map(Optional::get).anyMatch(this::checkLore)) {
            return true;
        }
        if (this.retrieve(stack, CookiesDataComponentTypes.SKYBLOCK_ID).flatMap(this::sanitize).map(this::checkId).orElse(false).booleanValue()) {
            return true;
        }
        if (this.retrieve(stack, CookiesDataComponentTypes.ENCHANTMENTS).map(this::checkEnchants).orElse(false).booleanValue()) {
            return true;
        }
        return this.retrieve(stack, CookiesDataComponentTypes.ATTRIBUTES).map(this::checkAttributes).orElse(false);
    }

    private boolean checkAttributes(Map<String, Integer> stringIntegerMap) {
        if (stringIntegerMap.containsKey("mending")) {
            stringIntegerMap.put("vitality", stringIntegerMap.get("mending"));
        }
        return this.checkLevelProperty(stringIntegerMap, this.attributes);
    }

    private boolean checkEnchants(Map<String, Integer> stringIntegerMap) {
        return this.checkLevelProperty(stringIntegerMap, this.enchants);
    }

    private boolean checkLevelProperty(Map<String, Integer> stringIntegerMap, List<LevelProperty> list) {
        for (LevelProperty levelProperty : list) {
            for (String attributeName : stringIntegerMap.keySet()) {
                String sanitizedAttributeName = attributeName.toLowerCase(Locale.ROOT).replace("_", " ").trim();
                if (!sanitizedAttributeName.contains(levelProperty.name)) continue;
                if (levelProperty.level.isPresent() && levelProperty.level.orElse(-1) != -1) {
                    return stringIntegerMap.getOrDefault(attributeName, 0).intValue() == levelProperty.level.orElse(-1);
                }
                return true;
            }
        }
        return false;
    }

    private <T> Optional<T> retrieve(class_1799 stack, class_9331<T> type) {
        if (stack == null) {
            return Optional.empty();
        }
        Object value = stack.method_57824(type);
        return Optional.ofNullable(value);
    }

    private boolean checkId(String s) {
        for (String string : this.id) {
            if (!s.contains(string)) continue;
            return true;
        }
        return false;
    }

    private boolean checkLore(String search) {
        for (String s : this.lore) {
            if (!search.contains(s)) continue;
            return true;
        }
        return false;
    }

    private Optional<String> sanitize(String original) {
        return Optional.of(original).map(CookiesUtils::stripColor).map(String::toLowerCase).map(String::trim);
    }

    private boolean checkName(String name) {
        for (String s : this.name) {
            if (!name.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public SearchQueryMatcher(boolean isRegex, String searchString, boolean negate, List<LevelProperty> attributes, List<LevelProperty> enchants, List<String> name, List<String> id, List<String> lore, List<SearchQueryMatcher> children, Predicate<class_1799> arbituaryPredicate) {
        this.isRegex = isRegex;
        this.searchString = searchString;
        this.negate = negate;
        this.attributes = attributes;
        this.enchants = enchants;
        this.name = name;
        this.id = id;
        this.lore = lore;
        this.children = children;
        this.arbituaryPredicate = arbituaryPredicate;
    }

    public static class Builder {
        private final List<LevelProperty> attributes = new ArrayList<LevelProperty>();
        private final List<LevelProperty> enchants = new ArrayList<LevelProperty>();
        private final List<String> name = new ArrayList<String>();
        private final List<String> id = new ArrayList<String>();
        private final List<String> lore = new ArrayList<String>();
        private final List<SearchQueryMatcher> children = new ArrayList<SearchQueryMatcher>();
        private boolean isRegex = false;
        private String searchString = null;
        private boolean negate = false;
        private Predicate<class_1799> arbituaryPredicate = Predicates.alwaysTrue();

        public Builder regex() {
            this.isRegex = true;
            return this;
        }

        public Builder predicate(Predicate<class_1799> predicate) {
            this.arbituaryPredicate = predicate;
            return this;
        }

        public Builder search(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public Builder negate() {
            this.negate = true;
            return this;
        }

        public Builder append(Builder other) {
            SearchQueryMatcher build = other.build();
            build.isRoot = false;
            this.children.add(build);
            return this;
        }

        public Builder attribute(String attribute, @Nullable Integer level) {
            return this.addProperty(attribute, level, this.attributes);
        }

        public Builder enchant(String enchant, @Nullable Integer level) {
            return this.addProperty(enchant, level, this.enchants);
        }

        private Builder addProperty(String property, @Nullable Integer level, List<LevelProperty> list) {
            if (this.isRegex) {
                return this;
            }
            list.add(new LevelProperty(property, Optional.ofNullable(level).map(OptionalInt::of).orElse(OptionalInt.empty())));
            return this;
        }

        private Builder addName(String name) {
            if (this.isRegex) {
                return this;
            }
            this.name.add(name);
            return this;
        }

        private Builder addId(String id) {
            if (this.isRegex) {
                return this;
            }
            this.id.add(id);
            return this;
        }

        private Builder addLore(String lore) {
            if (this.isRegex) {
                return this;
            }
            this.lore.add(lore);
            return this;
        }

        public SearchQueryMatcher build() {
            return new SearchQueryMatcher(this.isRegex, this.searchString, this.negate, this.attributes, this.enchants, this.name, this.id, this.lore, this.children, this.arbituaryPredicate);
        }

        private void parseString(String string, Consumer<String> consumer) {
            for (String s : string.trim().toLowerCase(Locale.ROOT).split(",")) {
                consumer.accept(s);
            }
        }

        public void parseLevelProperty(String remaining, BiConsumer<String, Integer> consumer) {
            for (String search : remaining.trim().toLowerCase(Locale.ROOT).split(",")) {
                String targetName;
                int level = -1;
                if (search.endsWith(")")) {
                    try {
                        level = Integer.parseInt(search.substring(search.indexOf("(") + 1, search.lastIndexOf(")")));
                        targetName = search.substring(0, search.lastIndexOf("(")).trim();
                    }
                    catch (NumberFormatException e) {
                        targetName = search;
                        level = -1;
                    }
                } else {
                    targetName = search;
                }
                String sanitizedTargetName = targetName.toLowerCase(Locale.ROOT).replace("(", "").replace(")", "").trim();
                consumer.accept(sanitizedTargetName, level);
            }
        }
    }

    private record LevelProperty(String name, OptionalInt level) {
    }
}

