/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.services.mining.powder;

import codes.cookies.mod.utils.cookies.PauseableTime;

public final class PowderEntry {
    private long powderGained = 0L;
    private PauseableTime pauseableTime = new PauseableTime(false);
    private long lastUpdate = -1L;
    private int other;

    public void reset() {
        this.powderGained = 0L;
        this.pauseableTime = new PauseableTime(false);
        this.lastUpdate = -1L;
        this.other = 0;
    }

    public void updateOther(int delta) {
        this.other += delta;
        this.lastUpdate = System.currentTimeMillis();
    }

    public void update(int delta) {
        if (delta < 0) {
            return;
        }
        this.powderGained += (long)delta;
        this.lastUpdate = System.currentTimeMillis();
        this.unpause();
    }

    public void unpause() {
        this.pauseableTime.unpause();
    }

    public void pause() {
        this.pauseableTime.pause();
    }

    public void pauseIfInactive() {
    }

    public long getGained() {
        this.pauseIfInactive();
        return this.powderGained;
    }

    public int getMillisecondsActive() {
        this.pauseIfInactive();
        return (int)this.pauseableTime.getTimePassed();
    }

    public double getGainesPerMinute() {
        return (float)this.getGained() / ((float)this.pauseableTime.getTimePassed() / 60000.0f);
    }

    public double getProjectedAmountPerHour() {
        return this.getGainesPerMinute() * 60.0;
    }

    public boolean isPaused() {
        return this.pauseableTime.isPaused();
    }

    public double getOtherPerMinute() {
        return (float)this.other / ((float)this.pauseableTime.getTimePassed() / 60000.0f);
    }

    public int getOtherTotal() {
        return this.other;
    }
}

