/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.services.mining.powder;

import codes.cookies.mod.data.mining.PowderType;
import codes.cookies.mod.events.ChatMessageEvents;
import codes.cookies.mod.events.mining.MineshaftEvents;
import codes.cookies.mod.events.mining.PowderUpdateEvent;
import codes.cookies.mod.services.mining.powder.PowderEntry;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_3545;

public class PowderService {
    private static final Map<PowderType, Map<Long, Integer>> powderTimeouts = new HashMap<PowderType, Map<Long, Integer>>();
    private static final Map<PowderType, PowderEntry> powderEntries = new HashMap<PowderType, PowderEntry>();

    private static void onMessage(class_2561 text, boolean overlay) {
        if (overlay) {
            return;
        }
        if (!LocationUtils.Island.CRYSTAL_HOLLOWS.isActive() && !LocationUtils.Island.DWARVEN_MINES.isActive()) {
            return;
        }
        String literalText = text.getString();
        if (literalText == null || literalText.isEmpty()) {
            return;
        }
        if ("You uncovered a treasure chest!".equalsIgnoreCase(literalText)) {
            powderEntries.get((Object)PowderType.GEMSTONE).updateOther(1);
        } else if ("WOW! You found a Glacite Mineshaft portal!".equalsIgnoreCase(literalText)) {
            ((Runnable)MineshaftEvents.FIND.invoker()).run();
        }
    }

    private static void countShaftJoin() {
    }

    private static void track(PowderType powderType, int amount, int delta) {
        Map<Long, Integer> longIntegerCache = powderTimeouts.get((Object)powderType);
        PowderService.invalidateOutdated(longIntegerCache);
        longIntegerCache.put(System.currentTimeMillis(), delta);
        PowderService.getPowderEntry(powderType).update(delta);
    }

    public static double getAverage(PowderType powderType) {
        PowderService.invalidateOutdated(powderTimeouts.get((Object)powderType));
        return powderTimeouts.get((Object)powderType).values().stream().mapToInt(i -> i).average().orElse(0.0);
    }

    public static Optional<PowderType> getCurrentlyActivePowderType() {
        return Arrays.stream(PowderType.values()).map(type -> new class_3545((Object)type, (Object)PowderService.getAverage(type))).filter(pair -> (Double)pair.method_15441() != 0.0).sorted(Comparator.comparingDouble(class_3545::method_15441).reversed()).map(class_3545::method_15442).findFirst();
    }

    public static PowderEntry getPowderEntry(PowderType powderType) {
        return powderEntries.get((Object)powderType);
    }

    public static void invalidateOutdated(Map<Long, Integer> list) {
    }

    static {
        PowderUpdateEvent.EVENT.register(PowderService::track);
        MineshaftEvents.JOIN.register(PowderService::countShaftJoin);
        ChatMessageEvents.BEFORE_MODIFY.register(PowderService::onMessage);
        for (PowderType value : PowderType.values()) {
            powderTimeouts.put(value, new HashMap());
            powderEntries.put(value, new PowderEntry());
        }
    }
}

