/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils;

import java.util.Optional;

public interface Either<A, B> {
    public boolean isLeft();

    public boolean isRight();

    public Optional<A> getLeft();

    public Optional<B> getRight();

    public static <A, B> Either<A, B> left(A a) {
        return new Left(a);
    }

    public static <A, B> Either<A, B> right(B b) {
        return new Right(b);
    }

    public record Left<A, B>(A a) implements Either<A, B>
    {
        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public Optional<A> getLeft() {
            return Optional.ofNullable(this.a);
        }

        @Override
        public Optional<B> getRight() {
            return Optional.empty();
        }
    }

    public record Right<A, B>(B b) implements Either<A, B>
    {
        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public Optional<A> getLeft() {
            return Optional.empty();
        }

        @Override
        public Optional<B> getRight() {
            return Optional.ofNullable(this.b);
        }
    }
}

