/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils;

import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public sealed interface RenderUtils {
    public static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"cookies-mod", (String)"textures/gui/blank.png");

    public static void renderBox(class_332 drawContext, int x, int y, int width, int height) {
        drawContext.method_25294(x, y, x + width, y + height, -13158601);
        drawContext.method_25294(x + 1, y + 1, x + width, y + height, -1);
        drawContext.method_25294(x + width, y, x + width - 1, y + 1, -7631989);
        drawContext.method_25294(x, y + height, x + 1, y + height - 1, -7631989);
        drawContext.method_25294(x + 1, y + 1, x + width - 1, y + height - 1, -7631989);
    }

    public static void renderBackgroundBox(class_332 drawContext, int x, int y, int width, int height, int color) {
        drawContext.method_25293(class_1921::method_62277, BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, 4, 4, 4, 4, 12, 12, color);
        drawContext.method_25293(class_1921::method_62277, BACKGROUND_TEXTURE, x + 4, y, 4.0f, 0.0f, width - 8, 4, 4, 4, 12, 12, color);
        drawContext.method_25293(class_1921::method_62277, BACKGROUND_TEXTURE, x + width - 4, y, 8.0f, 0.0f, 4, 4, 4, 4, 12, 12, color);
        drawContext.method_25293(class_1921::method_62277, BACKGROUND_TEXTURE, x, y + 4, 0.0f, 4.0f, 4, height - 8, 4, 4, 12, 12, color);
        drawContext.method_25293(class_1921::method_62277, BACKGROUND_TEXTURE, x + 4, y + 4, 4.0f, 4.0f, width - 8, height - 8, 4, 4, 12, 12, color);
        drawContext.method_25293(class_1921::method_62277, BACKGROUND_TEXTURE, x + width - 4, y + 4, 8.0f, 4.0f, 4, height - 8, 4, 4, 12, 12, color);
        drawContext.method_25293(class_1921::method_62277, BACKGROUND_TEXTURE, x, y + height - 4, 0.0f, 8.0f, 4, 4, 4, 4, 12, 12, color);
        drawContext.method_25293(class_1921::method_62277, BACKGROUND_TEXTURE, x + 4, y + height - 4, 4.0f, 8.0f, width - 8, 4, 4, 4, 12, 12, color);
        drawContext.method_25293(class_1921::method_62277, BACKGROUND_TEXTURE, x + width - 4, y + height - 4, 8.0f, 8.0f, 4, 4, 4, 4, 12, 12, color);
    }

    public static void renderFilledBox(class_332 drawContext, int x, int y, int width, int height) {
        drawContext.method_25294(x, y, width, height, -3750202);
    }

    public static void renderTextWithMaxWidth(@NotNull class_332 drawContext, @NotNull class_2561 text, int width, int x, int y, int color, boolean shadow) {
        class_327 textRenderer = RenderUtils.getTextRendererOrNull();
        if (textRenderer == null) {
            return;
        }
        int textWidth = textRenderer.method_27525((class_5348)text);
        float scale = 1.0f;
        if (textWidth > width) {
            scale = (float)width / (float)textWidth;
        }
        RenderUtils.renderTextScaled(drawContext, text, scale, x, y, color, shadow);
    }

    @Nullable
    private static class_327 getTextRendererOrNull() {
        if (class_310.method_1551() != null) {
            return class_310.method_1551().field_1772;
        }
        return null;
    }

    public static void renderTextScaled(@NotNull class_332 drawContext, @NotNull class_2561 text, float scaleFactor, int x, int y, int color, boolean shadow) {
        class_327 textRenderer = RenderUtils.getTextRendererOrNull();
        if (textRenderer == null) {
            return;
        }
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_22905(scaleFactor, scaleFactor, 1.0f);
        drawContext.method_51439(textRenderer, text, (int)((float)x / scaleFactor), (int)((float)y / scaleFactor), color, shadow);
        drawContext.method_51448().method_22909();
    }

    public static void renderTextCenteredScaled(@NotNull class_332 drawContext, @NotNull class_2561 text, float scaleFactor, int x, int y, int color) {
        class_327 textRenderer = RenderUtils.getTextRendererOrNull();
        if (textRenderer == null) {
            return;
        }
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_22905(scaleFactor, scaleFactor, 1.0f);
        drawContext.method_51439(textRenderer, text, (int)((float)x / scaleFactor) - textRenderer.method_27525((class_5348)text) / 2, (int)((float)y / scaleFactor), color, false);
        drawContext.method_51448().method_22909();
    }

    public static void renderTextInWorld(class_4587 matrixStack, class_243 position, class_2561 text, class_4597 vertexConsumerProvider, float size, boolean center, boolean throughWalls, int color) {
        class_310 minecraftClient = class_310.method_1551();
        class_4184 camera = minecraftClient.field_1773.method_19418();
        if (!camera.method_19332() || minecraftClient.method_1561().field_4692 == null) {
            return;
        }
        class_327 textRenderer = minecraftClient.field_1772;
        double d = camera.method_19326().field_1352;
        double e = camera.method_19326().field_1351;
        double f = camera.method_19326().field_1350;
        matrixStack.method_22903();
        matrixStack.method_46416((float)(position.field_1352 - d), (float)(position.field_1351 - e) + 0.07f, (float)(position.field_1350 - f));
        matrixStack.method_34425(new Matrix4f().rotation((Quaternionfc)camera.method_23767()));
        matrixStack.method_22905(-size, -size, size);
        float g = center ? (float)(-textRenderer.method_27525((class_5348)text)) / 2.0f : 0.0f;
        float backgroundOpacity = class_310.method_1551().field_1690.method_19343(0.25f);
        int background = (int)(backgroundOpacity * 255.0f) << 24;
        textRenderer.method_27522(text, g, 0.0f, color, false, matrixStack.method_23760().method_23761(), vertexConsumerProvider, class_327.class_6415.field_33994, background, 0xF000F0);
        matrixStack.method_22909();
    }

    public static void drawSlotHighlightBack(class_332 context, int slotX, int slotY) {
        context.method_52706(class_1921::method_62277, class_465.field_54268, slotX - 4, slotY - 4, 24, 24);
    }

    public static void drawSlotHighlightFront(class_332 context, int slotX, int slotY) {
        context.method_52706(class_1921::method_62275, class_465.field_54269, slotX - 4, slotY - 4, 24, 24);
    }

    public static class_243 getInterpolated(class_1297 entity, double tickDelta) {
        return new class_243(class_3532.method_16436((double)tickDelta, (double)entity.field_6038, (double)entity.method_23317()), class_3532.method_16436((double)tickDelta, (double)entity.field_5971, (double)entity.method_23318()), class_3532.method_16436((double)tickDelta, (double)entity.field_5989, (double)entity.method_23321()));
    }

    public static final class Sealed
    implements RenderUtils {
    }
}

