/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils;

import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Result<T, E> {
    public static <T, E> Result<T, E> success(@NotNull T value) {
        return new Success(value);
    }

    public static <T, E> Result<T, E> error(@NotNull E error) {
        return new Error(error);
    }

    public Optional<T> getResult();

    public Optional<E> getError();

    default public boolean isSuccess() {
        return this instanceof Success;
    }

    default public boolean isError() {
        return this instanceof Error;
    }

    default public Result<T, E> ifSuccess(Consumer<T> consumer) {
        Result result = this;
        if (result instanceof Success) {
            Success success = (Success)result;
            consumer.accept(success.type());
        }
        return this;
    }

    default public Result<T, E> ifError(Consumer<E> consumer) {
        Result result = this;
        if (result instanceof Error) {
            Error error = (Error)result;
            consumer.accept(error.error());
        }
        return this;
    }

    @Nullable
    default public T unbox() {
        return this.getResult().orElse(null);
    }

    @NotNull
    default public T unwrap() {
        return this.getResult().orElseThrow(NullPointerException::new);
    }

    public record Success<T, E>(@NotNull T type) implements Result<T, E>
    {
        @Override
        public Optional<T> getResult() {
            return Optional.of(this.type);
        }

        @Override
        public Optional<E> getError() {
            return Optional.empty();
        }
    }

    public record Error<T, E>(@NotNull E error) implements Result<T, E>
    {
        @Override
        public Optional<T> getResult() {
            return Optional.empty();
        }

        @Override
        public Optional<E> getError() {
            return Optional.of(this.error);
        }
    }
}

