/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.compatibility;

import codes.cookies.mod.utils.compatibility.system.CompatabilityMethod;
import codes.cookies.mod.utils.compatibility.system.Requires;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatibilityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompatibilityService.class);
    private static final List<Entry<?>> loaded = new ArrayList();

    public static <T> T get(Class<T> clazz) {
        for (Entry<?> entry : loaded) {
            if (!entry.entry.equals(clazz)) continue;
            return entry.value;
        }
        T load = CompatibilityService.load(clazz);
        loaded.add(new Entry<T>(clazz, load));
        return load;
    }

    private static <T> T load(Class<T> clazz) {
        boolean loadActual;
        if (clazz.isAnnotationPresent(Requires.class)) {
            Requires annotation = clazz.getAnnotation(Requires.class);
            String value = annotation.value();
            loadActual = FabricLoader.getInstance().isModLoaded(value);
        } else {
            loadActual = false;
        }
        if (loadActual) {
            try {
                Class<?> instanceClass = Class.forName(clazz.getName() + "Impl");
                return (T)instanceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
                log.error("Can't load compatibility tool, returning empty!");
            }
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            if (method.isAnnotationPresent(CompatabilityMethod.class)) {
                return null;
            }
            return method.invoke(proxy, args);
        });
    }

    public record Entry<T>(Class<T> entry, T value) {
    }
}

