/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.cookies;

import codes.cookies.mod.api.ws.WebsocketConnection;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dev.morazzer.cookies.entities.websocket.Packet;
import dev.morazzer.cookies.entities.websocket.packets.c2s.PlayersUseModRequestPacket;
import dev.morazzer.cookies.entities.websocket.packets.s2c.PlayersUseModResponsePacket;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class CookiesBackendUtils {
    private static final LoadingCache<UUID, Boolean> PLAYER_USE_MOD_CACHE;

    private static void updateCache(PlayersUseModResponsePacket playersUseModResponsePacket) {
        for (Map.Entry<UUID, Boolean> uuidBooleanEntry : playersUseModResponsePacket.map.entrySet()) {
            PLAYER_USE_MOD_CACHE.put((Object)uuidBooleanEntry.getKey(), (Object)uuidBooleanEntry.getValue());
        }
    }

    public static void requestUUIDS(UUID ... uuids) {
        WebsocketConnection.sendMessageAsync(new PlayersUseModRequestPacket(uuids));
    }

    private static Boolean loadUUID(UUID uuid) {
        CookiesBackendUtils.requestUUIDS(uuid);
        return false;
    }

    public static boolean usesMod(UUID uuid) {
        return (Boolean)PLAYER_USE_MOD_CACHE.getUnchecked((Object)uuid);
    }

    static {
        Packet.onReceive(PlayersUseModResponsePacket.class, CookiesBackendUtils::updateCache);
        PLAYER_USE_MOD_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(CookiesBackendUtils::loadUUID));
    }
}

