/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.cookies;

import codes.cookies.mod.utils.ColorUtils;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.joml.Vector2i;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookiesUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"cookies-utils");

    public static class_5250 createColor() {
        return class_2561.method_43473().method_27694(style -> style.method_36139(-1466946));
    }

    public static void sendRawMessage(String message) {
        CookiesUtils.sendMessage((class_2561)class_2561.method_43470((String)message));
    }

    public static void sendMessage(class_2561 text) {
        CookiesUtils.sendMessage(text, false);
    }

    public static void sendMessage(class_2561 text, boolean overlay) {
        CookiesUtils.getPlayer().ifPresent(clientPlayerEntity -> clientPlayerEntity.method_7353(text, overlay));
    }

    public static Optional<class_746> getPlayer() {
        return Optional.ofNullable(class_310.method_1551()).map(client -> client.field_1724);
    }

    public static void sendInformation(String message) {
        CookiesUtils.sendMessage(message);
    }

    public static void sendMessage(String text) {
        CookiesUtils.sendMessage((class_2561)CookiesUtils.createPrefix().method_27693(text));
    }

    public static class_5250 createPrefix() {
        return class_2561.method_43470((String)"Cookies Mod \u22d9 ").method_27694(style -> style.method_36139(-1466946));
    }

    public static void sendWhiteMessage(String message) {
        CookiesUtils.sendMessage((class_2561)CookiesUtils.createPrefix(-1).method_27693(message));
    }

    public static class_5250 createPrefix(int endColor) {
        LocalDateTime now = LocalDateTime.now();
        if (now.getMonth() == Month.JUNE) {
            return ColorUtils.literalWithGradient("\u3010Cookies Mod\u3011", 0xFF0000, 16753920, 0xFFFF00, 32768, 255, 4915330, 0xEE82EE, 0xEE82EE).method_54663(endColor);
        }
        if (now.getMonth() == Month.APRIL && now.getDayOfMonth() == 1) {
            Random random = new Random();
            return ColorUtils.literalWithGradient("\u3010Cookies Mod\u3011", random.nextInt(0xFFFFFF), random.nextInt(0xFFFFFF)).method_54663(endColor);
        }
        return ColorUtils.literalWithGradient("Cookies Mod \u22d9 ", -1466946, endColor);
    }

    public static void sendFailedMessage(String message) {
        CookiesUtils.sendMessage((class_2561)CookiesUtils.createPrefix(-38559).method_27693(message));
    }

    public static void sendFailedMessage(class_2561 message) {
        CookiesUtils.sendMessage((class_2561)CookiesUtils.createPrefix(-38559).method_10852(message));
    }

    public static void sendSuccessMessage(String message) {
        CookiesUtils.sendMessage((class_2561)CookiesUtils.createPrefix(-8921737).method_27693(message));
    }

    public static boolean match(String string, String search) {
        try {
            String withoutPrefix = search.startsWith("cookies-") ? search.substring(search.indexOf(58) + 1) : search;
            return switch (search.split(":")[0]) {
                case "cookies-regex" -> string.matches(withoutPrefix);
                case "cookies-equals" -> string.equals(withoutPrefix);
                case "cookies-behaviour" -> {
                    switch (withoutPrefix) {
                        case "always": {
                            yield true;
                        }
                        case "never": {
                            yield false;
                        }
                    }
                    throw new IllegalArgumentException("Unknown behaviour: " + withoutPrefix);
                }
                default -> string.equalsIgnoreCase(search);
            };
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
            return false;
        }
    }

    public static Vector2i mapToXZ(class_243 vec3d) {
        return new Vector2i((int)vec3d.field_1352, (int)vec3d.field_1350);
    }

    public static String stripColor(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("\u00a7[0-9a-fklmnor]", "");
    }

    public static String formattedMs(long time) {
        StringBuilder stringBuilder = new StringBuilder();
        long milliSeconds = time % 1000L;
        long secondsRemaining = time / 1000L;
        long seconds = secondsRemaining % 60L;
        long minutesRemaining = secondsRemaining / 60L;
        long minutes = minutesRemaining % 60L;
        long hoursRemaining = minutesRemaining / 60L;
        long hours = hoursRemaining % 24L;
        long daysRemaining = hoursRemaining / 24L;
        if (daysRemaining != 0L) {
            stringBuilder.append(daysRemaining).append("d ");
        }
        if (hours != 0L) {
            stringBuilder.append(hours).append("h ");
        }
        if (minutes != 0L) {
            stringBuilder.append(minutes).append("m ");
        }
        if (seconds != 0L) {
            stringBuilder.append(seconds).append("s ");
        }
        if (milliSeconds != 0L) {
            stringBuilder.append(milliSeconds).append("ms");
        }
        return stringBuilder.toString().trim();
    }

    public static void sendCommand(String command) {
        Optional.ofNullable(class_310.method_1551().field_1724).ifPresent(player -> player.field_3944.method_45731(command));
    }

    public static class_2338 mapToBlockPos(class_243 vec3d) {
        return new class_2338((int)Math.floor(vec3d.field_1352), (int)Math.floor(vec3d.field_1351), (int)Math.floor(vec3d.field_1350));
    }

    public static int parseIntSafe(String powderAmount) {
        return CookiesUtils.parseIntSafe(powderAmount, 0);
    }

    public static int parseIntSafe(String powderAmount, int defaultValue) {
        try {
            return Integer.parseInt(powderAmount);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"cookies-mod", (String)path);
    }
}

