/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.cookies;

public class PauseableTime {
    private final long startedAt = System.currentTimeMillis();
    private long pausedAt = System.currentTimeMillis();
    private long pausedFor = 0L;

    public PauseableTime(boolean start) {
        if (start) {
            this.unpause();
        }
    }

    public void unpause() {
        if (this.pausedAt == -1L) {
            return;
        }
        this.pausedFor += System.currentTimeMillis() - this.pausedAt;
        this.pausedAt = -1L;
    }

    public void pause() {
        if (this.isPaused()) {
            return;
        }
        this.pausedAt = System.currentTimeMillis();
    }

    public long getTimePassed() {
        if (this.pausedAt == -1L) {
            return System.currentTimeMillis() - (this.startedAt + this.pausedFor);
        }
        return this.pausedAt - (this.startedAt + this.pausedFor);
    }

    public boolean isPaused() {
        return this.pausedAt != -1L;
    }
}

