/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.dev;

import codes.cookies.mod.utils.json.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class DevInventoryUtils {
    private static final Path saved = Path.of("cookies/screens/saved", new String[0]);

    public static Optional<class_437> createInventory(String name) {
        String fileContent;
        Path resolve = saved.resolve(name + ".json");
        if (!Files.exists(resolve, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            fileContent = Files.readString(resolve);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonObject jsonObject = (JsonObject)JsonUtils.CLEAN_GSON.fromJson(fileContent, JsonObject.class);
        final class_1707 generic9x6 = class_1707.method_19251((int)-1, (class_1661)class_310.method_1551().field_1724.method_31548());
        final Map<Integer, class_1799> slots = DevInventoryUtils.getSlots(jsonObject.get("slots").getAsJsonObject());
        class_476 screen = new class_476(generic9x6, class_310.method_1551().field_1724.method_31548(), (class_2561)class_2561.class_2562.method_10872((JsonElement)jsonObject.get("name"), (class_7225.class_7874)class_310.method_1551().field_1687.method_30349())){

            protected void method_25426() {
                super.method_25426();
                slots.forEach((integer, itemStack) -> generic9x6.method_7619(integer.intValue(), 0, itemStack));
            }
        };
        return Optional.of(screen);
    }

    @NotNull
    private static Map<Integer, class_1799> getSlots(JsonObject jsonObject) {
        HashMap<Integer, class_1799> slots = new HashMap<Integer, class_1799>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            DataResult parse = class_1799.field_24671.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()));
            if (!parse.isSuccess()) continue;
            slots.put(Integer.parseInt((String)entry.getKey()), (class_1799)parse.getOrThrow());
        }
        return slots;
    }

    public static <T extends class_1703> Path saveInventory(class_465<T> handledScreen) throws IOException {
        if (!Files.exists(saved, new LinkOption[0])) {
            Files.createDirectories(saved, new FileAttribute[0]);
        }
        JsonObject slots = DevInventoryUtils.getSlots((class_2371<class_1735>)handledScreen.method_17577().field_7761);
        JsonObject screenValues = new JsonObject();
        screenValues.add("name", (JsonElement)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)handledScreen.method_25440()).getOrThrow());
        screenValues.addProperty("type", class_7923.field_41187.method_47983((Object)handledScreen.method_17577().method_17358()).method_55840());
        screenValues.add("slots", (JsonElement)slots);
        String fileName = "%s-%s.json".formatted(System.currentTimeMillis(), handledScreen.method_25440().getString().replaceAll("[^\\w\\-. ]", ""));
        Path path = saved.resolve(fileName);
        Files.writeString(path, (CharSequence)JsonUtils.CLEAN_GSON.toJson((JsonElement)screenValues), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return path;
    }

    @NotNull
    private static JsonObject getSlots(class_2371<class_1735> slots) {
        JsonObject slotsObject = new JsonObject();
        slots.forEach(slot -> {
            if (slot.field_7871 == class_310.method_1551().field_1724.method_31548()) {
                return;
            }
            class_1799 copy = slot.method_7677().method_7972();
            copy.method_57381(class_9334.field_49633);
            DataResult jsonElementDataResult = class_1799.field_24671.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)copy);
            Optional result = jsonElementDataResult.result();
            if (result.isEmpty()) {
                if (jsonElementDataResult.isError()) {
                    jsonElementDataResult.ifError(jsonElementError -> {
                        String message = jsonElementError.message();
                        System.err.println(message);
                    });
                }
                return;
            }
            slotsObject.add("" + slot.method_34266(), (JsonElement)result.get());
        });
        return slotsObject;
    }
}

