/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.dev;

import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.debug.ParticleDebugMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.slf4j.LoggerFactory;

public class DevUtils {
    private static final class_2960 ONLY_IN_DEV_ENV = class_2960.method_60655((String)"cookiesmod", (String)"disabled_in_prod");
    public static final Set<class_2960> availableTools = new HashSet<class_2960>();
    private static final Set<class_2960> enabledTools = new CopyOnWriteArraySet<class_2960>();
    private static final Set<class_2960> disabledTools = new CopyOnWriteArraySet<class_2960>(availableTools);
    private static final class_2960 EXTRA_LOGGING = DevUtils.createIdentifier("extra_logging");
    private static final List<String> enabledExtraLogging = new LinkedList<String>();

    public static void registerDebugs() {
        ParticleDebugMode.register();
    }

    public static boolean isExtraLoggingEnabled() {
        return DevUtils.isEnabled(EXTRA_LOGGING);
    }

    public static boolean isEnabled(class_2960 identifier) {
        return enabledTools.contains(identifier);
    }

    public static boolean isDisabled(class_2960 identifier) {
        return !DevUtils.isEnabled(identifier);
    }

    public static void log(String key, Object message, Object ... replacements) {
        if (!DevUtils.isExtraLoggingEnabled()) {
            return;
        }
        if (!enabledExtraLogging.isEmpty() && enabledExtraLogging.contains(key)) {
            CookiesUtils.sendWhiteMessage("%s".formatted(message).formatted(replacements));
            return;
        }
        LoggerFactory.getLogger((String)key).info("%s".formatted(message).formatted(replacements));
    }

    public static boolean enable(class_2960 identifier) {
        if (!availableTools.contains(identifier)) {
            return false;
        }
        enabledTools.add(identifier);
        disabledTools.remove(identifier);
        return true;
    }

    public static Set<class_2960> getEnabledTools() {
        return Collections.unmodifiableSet(enabledTools);
    }

    public static class_2960 createDevelopmentEnvIdentifier(String name) {
        if (!DevUtils.isDevEnvironment()) {
            return ONLY_IN_DEV_ENV;
        }
        return DevUtils.createIdentifier(name);
    }

    public static class_2960 createIdentifier(String name) {
        return DevUtils.createIdentifier(name, false);
    }

    public static class_2960 createIdentifier(String name, boolean defaultEnabled) {
        class_2960 identifier = class_2960.method_60655((String)"cookiesmod", (String)("dev/" + name));
        availableTools.add(identifier);
        DevUtils.disable(identifier);
        if (defaultEnabled) {
            DevUtils.enable(identifier);
        }
        return identifier;
    }

    public static boolean disable(class_2960 identifier) {
        if (!availableTools.contains(identifier)) {
            return false;
        }
        enabledTools.remove(identifier);
        disabledTools.add(identifier);
        return true;
    }

    public static boolean isDevEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static void runIf(class_2960 identifier, Runnable function) {
        if (DevUtils.isEnabled(identifier)) {
            function.run();
        }
    }

    public static void sendIf(class_2960 identifier, String text) {
        if (DevUtils.isEnabled(identifier)) {
            CookiesUtils.sendMessage(StackWalker.getInstance().getCallerClass().getSimpleName() + " > " + text);
        }
    }

    public static void sendIf(class_2960 identifier, class_2561 text) {
        if (DevUtils.isEnabled(identifier)) {
            CookiesUtils.sendMessage(text);
        }
    }

    @Generated
    public static Set<class_2960> getDisabledTools() {
        return disabledTools;
    }

    @Generated
    public static List<String> getEnabledExtraLogging() {
        return enabledExtraLogging;
    }
}

