/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.exceptions;

import codes.cookies.mod.utils.cookies.CookiesUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cookies-exception-handler");

    public static boolean tryCatch(ThrowableFunction<?> throwableFunction) {
        try {
            throwableFunction.run();
        }
        catch (Throwable exception) {
            ExceptionHandler.handleException(exception);
            return false;
        }
        return true;
    }

    public static void handleException(Throwable exception) {
        LOGGER.error("An exception occurred", exception);
        CookiesUtils.getPlayer().ifPresent(player -> {
            String stackTrace = ExceptionHandler.getStacktrace(exception);
            String copy = "```\nVersion: %s\nVM: %s\nMod: %s\nException type: %s\n\n--------------------------\n\nStacktrace:\n%s\n```".formatted(class_310.method_1551().method_1515(), ManagementFactory.getRuntimeMXBean().getVmVendor() + " " + ManagementFactory.getRuntimeMXBean().getVmName() + " " + ManagementFactory.getRuntimeMXBean().getVmVersion(), "Cookies mod", exception.getClass().getSimpleName(), stackTrace);
            player.method_7353((class_2561)CookiesUtils.createPrefix(-38559).method_10852((class_2561)class_2561.method_43471((String)"cookies.internal_error").method_27694(style -> style.method_36139(-38559).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"%s: %s".formatted(exception.getClass().getName(), exception.getMessage())))).method_10958(new class_2558(class_2558.class_2559.field_21462, copy)))), false);
        });
    }

    public static String getStacktrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static boolean tryCatch(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception);
            return false;
        }
        return true;
    }

    public static <T> T removeThrows(ThrowableFunction<T> throwableFunction) {
        return ExceptionHandler.removeThrows(throwableFunction, null);
    }

    public static <T> T removeThrows(ThrowableFunction<T> throwableFunction, T defaultObject) {
        try {
            return throwableFunction.run();
        }
        catch (Throwable e) {
            ExceptionHandler.handleException(e);
            return defaultObject;
        }
    }

    public static <T> T removeThrowsSilent(ThrowableFunction<T> throwableFunction, T defaultObject) {
        try {
            return throwableFunction.run();
        }
        catch (Throwable e) {
            return defaultObject;
        }
    }

    public static <T> T wrap(T function) {
        AtomicBoolean failed = new AtomicBoolean();
        return (T)Proxy.newProxyInstance(function.getClass().getClassLoader(), function.getClass().getInterfaces(), (proxy, method, args) -> {
            if (failed.get()) {
                return null;
            }
            try {
                return method.invoke(function, args);
            }
            catch (Exception e) {
                CookiesUtils.sendMessage((class_2561)CookiesUtils.createPrefix(-38559).method_27693("One of the features you used crashed, it will be disabled for now!"));
                ExceptionHandler.handleException(e);
                failed.set(true);
                return null;
            }
        });
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T> {
        public T run() throws Throwable;
    }
}

