/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.items;

import codes.cookies.mod.utils.RenderUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import org.joml.Matrix4f;

public class ItemTooltipComponent
implements class_5684 {
    private static final class_2960 SLOT = class_2960.method_60655((String)"cookies-mod", (String)"textures/gui/slot.png");
    private final Map<Integer, class_1799> entries;
    private final int size;
    private final int amountInRow;
    private List<class_5683> tooltip;

    public ItemTooltipComponent(Map<Integer, class_1799> entries) {
        this(entries, 9, Collections.emptyList());
    }

    public ItemTooltipComponent(Map<Integer, class_1799> entries, int columnsInRow, List<class_2561> tooltip) {
        this.amountInRow = columnsInRow;
        OptionalInt optionalMax = entries.keySet().stream().mapToInt(Integer::valueOf).max();
        if (optionalMax.isEmpty()) {
            this.entries = Collections.emptyMap();
            this.size = 0;
            return;
        }
        this.entries = entries;
        this.size = optionalMax.getAsInt() + 1;
        this.tooltip = tooltip.stream().map(class_2561::method_30937).map(class_5683::new).toList();
    }

    public ItemTooltipComponent(Iterable<class_1799> entries, int columnsInRow, List<class_2561> tooltip) {
        this(ItemTooltipComponent.toMap(entries), columnsInRow, tooltip);
    }

    private static Map<Integer, class_1799> toMap(Iterable<class_1799> entries) {
        HashMap<Integer, class_1799> map = new HashMap<Integer, class_1799>();
        int index = 0;
        for (class_1799 entry : entries) {
            map.put(index++, entry);
        }
        return map;
    }

    public int method_32661(class_327 textRenderer) {
        return this.getRowsHeight() + 7 + this.getTotalTextHeight(textRenderer);
    }

    public int method_32664(class_327 textRenderer) {
        return Math.max(this.getColumnsWidth(), this.getTextWidth(textRenderer));
    }

    public void method_32665(class_327 textRenderer, int x, int y, Matrix4f matrix, class_4597.class_4598 vertexConsumers) {
        int newY = y;
        for (class_5683 orderedTextTooltipComponent : this.tooltip) {
            orderedTextTooltipComponent.method_32665(textRenderer, x, newY, matrix, vertexConsumers);
            newY += orderedTextTooltipComponent.method_32661(textRenderer);
        }
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        RenderUtils.renderBackgroundBox(context, x, y += this.getTotalTextHeight(textRenderer), this.getColumnsWidth(), this.getRowsHeight(), -1);
        for (int index = 0; index < this.size; ++index) {
            int slotY = index / this.amountInRow;
            int slotX = index % this.amountInRow;
            this.drawSlot(slotX * 18 + 4 + 1 + x, slotY * 18 + 4 + 1 + y, index, context, textRenderer);
        }
    }

    private void drawSlot(int x, int y, int index, class_332 context, class_327 textRenderer) {
        if (index >= this.size) {
            this.draw(context, x, y);
        } else {
            class_1799 itemStack = this.entries.getOrDefault(index, class_1799.field_8037);
            this.draw(context, x, y);
            Integer data = ItemUtils.getData(itemStack, CookiesDataComponentTypes.ITEM_BACKGROUND_COLOR);
            if (data != null) {
                context.method_25294(x + 1, y + 1, x + 17, y + 17, data.intValue());
            }
            context.method_51428(itemStack, x + 1, y + 1, index);
            context.method_51431(textRenderer, itemStack, x + 1, y + 1);
        }
    }

    private void draw(class_332 context, int x, int y) {
        context.method_25290(class_1921::method_62277, SLOT, x, y, 0.0f, 0.0f, 18, 18, 18, 18);
    }

    private int getColumnsWidth() {
        return this.getColumns() * 18 + 10;
    }

    public int getTextWidth(class_327 textRenderer) {
        return this.tooltip.stream().mapToInt(component -> component.method_32664(textRenderer)).max().orElse(0);
    }

    private int getRowsHeight() {
        return this.getRows() * 18 + 10;
    }

    public int getTotalTextHeight(class_327 textRenderer) {
        return this.tooltip.stream().mapToInt(value -> value.method_32661(textRenderer)).sum();
    }

    private int getRows() {
        return this.size / this.getColumns() + (this.size % this.getColumns() != 0 ? 1 : 0);
    }

    private int getColumns() {
        return Math.min(this.size, this.amountInRow);
    }
}

