/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.items;

import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import lombok.Generated;

public record PetInfo(String type, boolean active, double exp, RepositoryItem.Tier tier, boolean hideInfo, int candyUsed, boolean hideRightClick, boolean noMove) {
    public static PetInfo EMPTY = new PetInfo("PET", false, 0.0, RepositoryItem.Tier.COMMON, false, 0, false, false);

    public static PetInfo create(String s) {
        if (s == null) {
            return EMPTY;
        }
        JsonElement jsonElement = JsonParser.parseString((String)s);
        if (!jsonElement.isJsonObject()) {
            return EMPTY;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        PetInfoBuilder builder = PetInfo.builder();
        builder.type(EMPTY.type()).tier(EMPTY.tier());
        if (jsonObject.has("type")) {
            builder.type(jsonObject.get("type").getAsString());
        }
        if (jsonObject.has("active")) {
            builder.active(jsonObject.get("active").getAsBoolean());
        }
        if (jsonObject.has("exp")) {
            builder.exp(jsonObject.get("exp").getAsDouble());
        }
        if (jsonObject.has("tier")) {
            builder.tier(ExceptionHandler.removeThrowsSilent(() -> RepositoryItem.Tier.valueOf(jsonObject.get("tier").getAsString()), RepositoryItem.Tier.COMMON));
        }
        if (jsonObject.has("hideInfo")) {
            builder.hideInfo(jsonObject.get("hideInfo").getAsBoolean());
        }
        if (jsonObject.has("candyUsed")) {
            builder.candyUsed(jsonObject.get("candyUsed").getAsInt());
        }
        if (jsonObject.has("hideRightClick")) {
            builder.hideRightClick(jsonObject.get("hideRightClick").getAsBoolean());
        }
        if (jsonObject.has("noMove")) {
            builder.noMove(jsonObject.get("noMove").getAsBoolean());
        }
        return builder.build();
    }

    @Generated
    public static PetInfoBuilder builder() {
        return new PetInfoBuilder();
    }

    @Generated
    public static class PetInfoBuilder {
        @Generated
        private String type;
        @Generated
        private boolean active;
        @Generated
        private double exp;
        @Generated
        private RepositoryItem.Tier tier;
        @Generated
        private boolean hideInfo;
        @Generated
        private int candyUsed;
        @Generated
        private boolean hideRightClick;
        @Generated
        private boolean noMove;

        @Generated
        PetInfoBuilder() {
        }

        @Generated
        public PetInfoBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public PetInfoBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public PetInfoBuilder exp(double exp) {
            this.exp = exp;
            return this;
        }

        @Generated
        public PetInfoBuilder tier(RepositoryItem.Tier tier) {
            this.tier = tier;
            return this;
        }

        @Generated
        public PetInfoBuilder hideInfo(boolean hideInfo) {
            this.hideInfo = hideInfo;
            return this;
        }

        @Generated
        public PetInfoBuilder candyUsed(int candyUsed) {
            this.candyUsed = candyUsed;
            return this;
        }

        @Generated
        public PetInfoBuilder hideRightClick(boolean hideRightClick) {
            this.hideRightClick = hideRightClick;
            return this;
        }

        @Generated
        public PetInfoBuilder noMove(boolean noMove) {
            this.noMove = noMove;
            return this;
        }

        @Generated
        public PetInfo build() {
            return new PetInfo(this.type, this.active, this.exp, this.tier, this.hideInfo, this.candyUsed, this.hideRightClick, this.noMove);
        }

        @Generated
        public String toString() {
            return "PetInfo.PetInfoBuilder(type=" + this.type + ", active=" + this.active + ", exp=" + this.exp + ", tier=" + String.valueOf((Object)this.tier) + ", hideInfo=" + this.hideInfo + ", candyUsed=" + this.candyUsed + ", hideRightClick=" + this.hideRightClick + ", noMove=" + this.noMove + ")";
        }
    }
}

