/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.json;

import codes.cookies.mod.utils.json.JsonSerializable;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public interface CodecJsonSerializable<T>
extends JsonSerializable {
    @Override
    default public JsonElement write() {
        T value = this.getValue();
        if (value == null) {
            return null;
        }
        DataResult result = this.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, value);
        if (result.isError()) {
            this.getLogger().warn("Failed to save data! {}", (Object)((DataResult.Error)result.error().get()).message());
            return null;
        }
        return (JsonElement)result.getOrThrow();
    }

    @Override
    default public void read(@NotNull JsonElement jsonElement) {
        try {
            DataResult parse = this.getCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            if (parse.isSuccess()) {
                this.load(parse.getOrThrow());
            } else {
                this.getLogger().warn("Failed to load data from a CodecJsonSerializable, trying to load partial. {}", (Object)((DataResult.Error)parse.error().get()).message());
                try {
                    this.load(parse.getOrThrow());
                }
                catch (Exception e) {
                    this.getLogger().error("Failed to load partial data, continuing with empty list.");
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred while trying to the data.", (Throwable)e);
        }
    }

    public Codec<T> getCodec();

    public void load(T var1);

    public T getValue();

    public Logger getLogger();
}

