/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.json;

import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.json.Exclude;
import codes.cookies.mod.utils.json.JsonSerializable;
import codes.cookies.mod.utils.json.Safe;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncArray;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncElement;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncObject;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncPrimitive;
import java.lang.reflect.Field;

public class JsonUtils {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    public static final Gson CLEAN_GSON = new Gson();

    public static JsonObject toJsonObject(Object instance) {
        JsonObject jsonObject = new JsonObject();
        for (Field field : instance.getClass().getDeclaredFields()) {
            field.trySetAccessible();
            String fieldName = JsonUtils.getEffectiveName(field);
            if (field.isAnnotationPresent(Exclude.class)) continue;
            if (JsonSerializable.class.isAssignableFrom(field.getType())) {
                JsonSerializable serializer = (JsonSerializable)ExceptionHandler.removeThrows(() -> field.get(instance));
                jsonObject.add(fieldName, serializer.write());
                continue;
            }
            if (field.isAnnotationPresent(Safe.class)) {
                jsonObject.add(fieldName, (JsonElement)ExceptionHandler.removeThrows(() -> JsonUtils.toJsonObject(field.get(instance))));
                continue;
            }
            jsonObject.add(fieldName, ExceptionHandler.removeThrows(() -> CLEAN_GSON.toJsonTree(field.get(instance))));
        }
        return jsonObject;
    }

    public static <T> T fromJson(T instance, JsonObject jsonObject) {
        for (Field field : instance.getClass().getDeclaredFields()) {
            field.trySetAccessible();
            String fieldName = JsonUtils.getEffectiveName(field);
            if (field.isAnnotationPresent(Exclude.class)) continue;
            if (JsonSerializable.class.isAssignableFrom(field.getType())) {
                if (!jsonObject.has(fieldName)) continue;
                JsonSerializable serializer = (JsonSerializable)ExceptionHandler.removeThrows(() -> field.get(instance));
                serializer.read(jsonObject.get(fieldName));
                continue;
            }
            if (field.isAnnotationPresent(Safe.class)) {
                if (!jsonObject.has(fieldName)) continue;
                JsonUtils.fromJson(ExceptionHandler.removeThrows(() -> field.get(instance)), jsonObject.get(fieldName).getAsJsonObject());
                continue;
            }
            if (!jsonObject.has(fieldName)) continue;
            try {
                field.set(instance, CLEAN_GSON.fromJson(jsonObject.get(fieldName), field.getType()));
            }
            catch (IllegalAccessException e) {
                ExceptionHandler.handleException(new RuntimeException(field.getDeclaringClass().getName() + "#" + field.getName(), e));
            }
        }
        return instance;
    }

    private static String getEffectiveName(Field field) {
        if (field.isAnnotationPresent(SerializedName.class)) {
            return field.getAnnotation(SerializedName.class).value();
        }
        return field.getName().replaceAll("([a-z1-9])([A-Z])", "$1_$2").toLowerCase();
    }

    public static JsoncElement toJsonc(JsonElement write) {
        if (write.isJsonPrimitive()) {
            if (write.getAsJsonPrimitive().isNumber()) {
                return new JsoncPrimitive(write.getAsJsonPrimitive().getAsNumber());
            }
            if (write.getAsJsonPrimitive().isBoolean()) {
                return new JsoncPrimitive(write.getAsJsonPrimitive().getAsBoolean());
            }
            if (write.getAsJsonPrimitive().isString()) {
                return new JsoncPrimitive(write.getAsJsonPrimitive().getAsString());
            }
        } else {
            if (write.isJsonObject()) {
                JsoncObject jsoncObject = new JsoncObject();
                write.getAsJsonObject().entrySet().forEach(entry -> jsoncObject.add((String)entry.getKey(), JsonUtils.toJsonc((JsonElement)entry.getValue())));
                return jsoncObject;
            }
            if (write.isJsonArray()) {
                JsoncArray jsoncArray = new JsoncArray();
                write.getAsJsonArray().forEach(jsonElement -> jsoncArray.add(JsonUtils.toJsonc(jsonElement)));
                return jsoncArray;
            }
        }
        throw new UnsupportedOperationException();
    }
}

