/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.maths;

import codes.cookies.mod.utils.maths.LinearInterpolatedInteger;
import codes.cookies.mod.utils.maths.SigmoidInterpolatedInteger;
import lombok.Generated;

public abstract sealed class InterpolatedInteger
permits LinearInterpolatedInteger, SigmoidInterpolatedInteger {
    protected final long timeToTarget;
    protected long timeSpend;
    protected int value;
    protected int targetValue;
    protected int startValue;
    protected long lastMillis;
    protected boolean hasReachedTarget;

    public InterpolatedInteger(long timeToTarget, int startValue) {
        this.timeToTarget = timeToTarget;
        this.startValue = startValue;
        this.value = startValue;
        this.hasReachedTarget = true;
    }

    public void setTargetValue(int targetValue) {
        this.setTargetValue(targetValue, false);
    }

    public void setTargetValue(int targetValue, boolean force) {
        if (!force && targetValue == this.targetValue) {
            return;
        }
        this.startValue = this.value;
        this.targetValue = targetValue;
        this.timeSpend = 0L;
        this.lastMillis = System.currentTimeMillis();
        this.hasReachedTarget = false;
    }

    public long lastMillis() {
        return this.lastMillis;
    }

    public abstract void tick(long var1);

    public boolean hasReachedTarget() {
        return this.hasReachedTarget;
    }

    public int getTarget() {
        return this.targetValue;
    }

    public void tick() {
        if (this.hasReachedTarget()) {
            return;
        }
        this.tick(System.currentTimeMillis() - this.lastMillis());
    }

    @Generated
    public void setValue(int value) {
        this.value = value;
    }

    @Generated
    public int getValue() {
        return this.value;
    }
}

