/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.maths;

import codes.cookies.mod.utils.maths.InterpolatedInteger;

public non-sealed class LinearInterpolatedInteger
extends InterpolatedInteger {
    public LinearInterpolatedInteger(long timeToTarget, int startValue) {
        super(timeToTarget, startValue);
    }

    @Override
    public void tick(long deltaTime) {
        if (this.hasReachedTarget) {
            return;
        }
        this.timeSpend += deltaTime;
        float time = (float)this.timeSpend / (float)this.timeToTarget;
        if (time > 1.0f) {
            this.hasReachedTarget = true;
            this.value = this.targetValue;
            return;
        }
        this.value = (int)((1.0f - time) * (float)this.startValue + time * (float)this.targetValue);
        this.lastMillis = System.currentTimeMillis();
    }
}

