/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.maths;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Range;

public enum RomanNumerals {
    I(1),
    IV(4),
    V(5),
    IX(9),
    X(10),
    XL(40),
    L(50),
    XC(90),
    C(100),
    CD(400),
    D(500),
    CM(900),
    M(1000);

    private final int value;

    private RomanNumerals(int value) {
        this.value = value;
    }

    private static List<RomanNumerals> getReverseSortedValues() {
        return Arrays.stream(RomanNumerals.values()).sorted(Comparator.comparing(e -> e.value).reversed()).collect(Collectors.toList());
    }

    public static int romanToArabic(String input) {
        String romanNumeral = input.toUpperCase();
        int result = 0;
        List<RomanNumerals> romanNumerals = RomanNumerals.getReverseSortedValues();
        int i = 0;
        while (!romanNumeral.isEmpty() && i < romanNumerals.size()) {
            RomanNumerals symbol = romanNumerals.get(i);
            if (romanNumeral.startsWith(symbol.name())) {
                result += symbol.getValue();
                romanNumeral = romanNumeral.substring(symbol.name().length());
                continue;
            }
            ++i;
        }
        if (!romanNumeral.isEmpty()) {
            return -1;
        }
        return result;
    }

    public static String toRoman(@Range(from=1L, to=3999L) int number) {
        List<RomanNumerals> romanNumerals = RomanNumerals.getReverseSortedValues();
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (number > 0 && i < romanNumerals.size()) {
            RomanNumerals currentSymbol = romanNumerals.get(i);
            if (currentSymbol.getValue() <= number) {
                sb.append(currentSymbol.name());
                number -= currentSymbol.getValue();
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    @Generated
    public int getValue() {
        return this.value;
    }
}

