/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.maths;

import codes.cookies.mod.utils.maths.InterpolatedInteger;
import codes.cookies.mod.utils.maths.MathUtils;

public final class SigmoidInterpolatedInteger
extends InterpolatedInteger {
    public SigmoidInterpolatedInteger(long timeToTarget, int startValue) {
        super(timeToTarget, startValue);
    }

    @Override
    public void tick(long deltaTime) {
        if (this.hasReachedTarget) {
            return;
        }
        this.timeSpend += deltaTime;
        float time = (float)this.timeSpend / (float)this.timeToTarget;
        if (time > 1.0f) {
            this.hasReachedTarget = true;
            this.value = this.targetValue;
            return;
        }
        float progress = MathUtils.sigmoidZeroOne(time);
        this.value = (int)((1.0f - progress) * (float)this.startValue + progress * (float)this.targetValue);
        this.lastMillis = System.currentTimeMillis();
    }
}

