/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.mixins;

import codes.cookies.mod.config.categories.MiscCategory;
import codes.cookies.mod.utils.accessors.FocusedSlotAccessor;
import codes.cookies.mod.utils.accessors.InventoryScreenAccessor;
import codes.cookies.mod.utils.accessors.SlotAccessor;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevInventoryUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemTooltipComponent;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.items.ScrollableTooltipHandler;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5632;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_465.class})
public abstract class HandledScreenMixin
implements InventoryScreenAccessor {
    @Unique
    private static final class_2960 ALLOW_SCREEN_SAVING = DevUtils.createIdentifier("save_handled_screens");
    @Unique
    private static final class_2960 ITEM_DEBUG_MODE = DevUtils.createIdentifier("item_debug_mode");
    @Unique
    private final List<InventoryScreenAccessor.Disabled> cookies$disabled = new ArrayList<InventoryScreenAccessor.Disabled>();
    @Shadow
    public int field_2779;
    @Shadow
    public int field_2792;
    @Shadow
    public int field_2776;
    @Shadow
    public int field_2800;
    @Shadow
    @Nullable
    public class_1735 field_2787;

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (DevUtils.isEnabled(ALLOW_SCREEN_SAVING) && keyCode == 83) {
            try {
                Path path = DevInventoryUtils.saveInventory((class_465)this);
                CookiesUtils.sendMessage((class_2561)CookiesUtils.createPrefix().method_27693("Saved inventory to file %s".formatted(path.getFileName())).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, path.getFileName().toString().split("\\.")[0]))));
                cir.setReturnValue((Object)true);
            }
            catch (IOException ioException) {
                CookiesUtils.sendFailedMessage("Failed to writing inventory file");
                ExceptionHandler.handleException(ioException);
            }
            catch (Exception exception) {
                ExceptionHandler.handleException(exception);
            }
            return;
        }
        if (this.field_2787 != null && DevUtils.isEnabled(ITEM_DEBUG_MODE)) {
            class_1735 focusedSlot = this.field_2787;
            class_1799 stack = focusedSlot.method_7677();
            if (stack.method_7960()) {
                return;
            }
            if (keyCode == 69) {
                class_310.method_1551().field_1774.method_1455((String)stack.method_57824(CookiesDataComponentTypes.SKYBLOCK_ID));
                CookiesUtils.sendSuccessMessage("Copied skyblock id!");
                cir.setReturnValue((Object)true);
            } else if (keyCode == 83 && stack.method_31574(class_1802.field_8575)) {
                class_9296 skin = (class_9296)stack.method_57824(class_9334.field_49617);
                if (skin == null) {
                    CookiesUtils.sendFailedMessage("Item does not have a skin attached!");
                    cir.setReturnValue((Object)true);
                    return;
                }
                skin.comp_2413().getProperties().forEach((string, property) -> System.out.printf("%s - %s%n", string, property.value()));
                Collection textures = skin.comp_2413().getProperties().get((Object)"textures");
                Iterator iterator = textures.iterator();
                if (iterator.hasNext()) {
                    Property texture = (Property)iterator.next();
                    class_310.method_1551().field_1774.method_1455(texture.value());
                    CookiesUtils.sendSuccessMessage("Copied skin!");
                    cir.setReturnValue((Object)true);
                    return;
                }
            } else if (keyCode == 78) {
                class_310.method_1551().field_1774.method_1455(stack.method_7964().getString());
                cir.setReturnValue((Object)true);
            }
        }
    }

    @WrapOperation(method={"drawMouseoverTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTooltip(Lnet/minecraft/client/font/TextRenderer;Ljava/util/List;Ljava/util/Optional;IILnet/minecraft/util/Identifier;)V")})
    public void drawTooltip(class_332 instance, class_327 textRenderer, List<class_2561> text, Optional<class_5632> data, int x, int y, @Nullable class_2960 texture, Operation<Void> original) {
        class_5683 orderedTextTooltipComponent;
        int width;
        class_5684 tooltipComponent;
        if (this.field_2787 == null) {
            return;
        }
        class_1799 stack = this.field_2787.method_7677();
        ItemTooltipComponent loreItems = ItemUtils.getData(stack, CookiesDataComponentTypes.LORE_ITEMS);
        if (loreItems == null && !DevUtils.isEnabled(ITEM_DEBUG_MODE)) {
            original.call(new Object[]{instance, textRenderer, text, data, x, y, texture});
            return;
        }
        List list = (List)text.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(class_156.method_58579());
        if (loreItems != null) {
            list.add(list.isEmpty() ? 0 : 1, loreItems);
            data.ifPresent(data2 -> list.add(1, class_5684.method_32663((class_5632)data2)));
        }
        if (DevUtils.isEnabled(ITEM_DEBUG_MODE)) {
            String skyblockId = (String)stack.method_57824(CookiesDataComponentTypes.SKYBLOCK_ID);
            list.add(new class_5683(class_2561.method_43473().method_30937()));
            if (skyblockId != null) {
                boolean foundRepositoryItem = stack.method_57826(CookiesDataComponentTypes.REPOSITORY_ITEM);
                class_5250 formatted = class_2561.method_43470((String)"[E] ").method_10852((class_2561)class_2561.method_43470((String)skyblockId).method_27692(class_124.field_1080)).method_27692(class_124.field_1065);
                if (foundRepositoryItem) {
                    formatted.method_10852((class_2561)class_2561.method_43470((String)" (Found)").method_27692(class_124.field_1060));
                } else {
                    formatted.method_10852((class_2561)class_2561.method_43470((String)" (Not found)").method_27692(class_124.field_1061));
                }
                list.add(new class_5683(formatted.method_30937()));
            }
            if (stack.method_31574(class_1802.field_8575) && stack.method_57824(class_9334.field_49617) != null) {
                list.add(new class_5683(class_2561.method_43470((String)"[S] ").method_10852((class_2561)class_2561.method_43470((String)"To copy skin").method_27692(class_124.field_1080)).method_27692(class_124.field_1065).method_30937()));
            }
            list.add(new class_5683(class_2561.method_43470((String)"[N] ").method_10852((class_2561)class_2561.method_43470((String)"To copy name").method_27692(class_124.field_1080)).method_27692(class_124.field_1065).method_30937()));
        }
        if ((tooltipComponent = (class_5684)list.removeLast()) instanceof class_5683 && (width = (orderedTextTooltipComponent = (class_5683)tooltipComponent).method_32664(textRenderer)) != 0) {
            list.add(tooltipComponent);
        }
        instance.method_51435(textRenderer, list, x, y, class_8001.field_41687, null);
    }

    @Inject(method={"mouseScrolled"}, at={@At(value="HEAD")}, cancellable=true)
    public void onScroll(CallbackInfoReturnable<Boolean> cir, @Local(argsOnly=true, ordinal=2) double horizontalAmount, @Local(argsOnly=true, ordinal=3) double verticalAmount) {
        if (!MiscCategory.enableScrollableTooltips) {
            return;
        }
        HandledScreenMixin handledScreenMixin = this;
        if (handledScreenMixin instanceof class_465) {
            class_465 handledScreen = (class_465)handledScreenMixin;
            class_1735 focusedSlot = FocusedSlotAccessor.getFocusedSlot(handledScreen);
            if (handledScreen.method_17577().method_34255().method_7960() && focusedSlot != null && focusedSlot.method_7681()) {
                class_1799 stack = focusedSlot.method_7677();
                ScrollableTooltipHandler.scroll(stack, horizontalAmount, verticalAmount);
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Override
    public int cookies$getBackgroundWidth() {
        return this.field_2792;
    }

    @Override
    public int cookies$getBackgroundHeight() {
        return this.field_2779;
    }

    @Override
    public int cookies$getX() {
        return this.field_2776;
    }

    @Override
    public int cookies$getY() {
        return this.field_2800;
    }

    @Override
    public List<InventoryScreenAccessor.Disabled> cookies$getDisabled() {
        return this.cookies$disabled;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Util;getMeasuringTimeMs()J")}, cancellable=true)
    private void cancelMouseClick(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir, @Local class_1735 slot) {
        if (slot == null) {
            return;
        }
        if (SlotAccessor.getInteractionLocked(slot)) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (SlotAccessor.getOnClick(slot) != null) {
            SlotAccessor.getOnClick(slot).accept(button);
            cir.setReturnValue((Object)true);
            return;
        }
        if (SlotAccessor.getRunnable(slot) != null) {
            SlotAccessor.getRunnable(slot).run();
            cir.setReturnValue((Object)true);
            return;
        }
        if (SlotAccessor.getItem(slot) != null) {
            cir.setReturnValue((Object)true);
        }
        if (SlotAccessor.getOnItemClickRunnable(slot) != null) {
            SlotAccessor.getOnItemClickRunnable(slot).run();
        }
    }

    @ModifyArgs(method={"drawSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawStackOverlay(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V"))
    private void drawItem$drawItemInSlot(Args args) {
        class_1799 itemStack = (class_1799)args.get(1);
        String text = ItemUtils.getData(itemStack, CookiesDataComponentTypes.CUSTOM_SLOT_TEXT);
        if (text != null) {
            args.set(4, (Object)text);
        }
    }
}

