/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.mixins;

import codes.cookies.mod.config.ConfigManager;
import codes.cookies.mod.config.categories.MiscCategory;
import codes.cookies.mod.events.ItemLoreEvent;
import codes.cookies.mod.events.ItemStackEvents;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.accessors.CustomComponentMapAccessor;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.items.PetInfo;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin
implements class_9322 {
    @Shadow
    @Final
    class_9335 field_49270;

    @Inject(method={"<init>(Lnet/minecraft/item/ItemConvertible;ILnet/minecraft/component/MergedComponentMap;)V"}, at={@At(value="RETURN")})
    public void initializeItemStackWithComponents(class_1935 itemConvertible, int i, class_9335 componentMapImpl, CallbackInfo ci) {
        int ordinal;
        String s;
        RepositoryItem repositoryItem;
        PetInfo petInfo;
        this.cookies$setComponents();
        CookiesDataComponentTypes.getDataTypes().forEach(this::cookies$registerType);
        class_9279 nbtComponent = (class_9279)componentMapImpl.method_57829(class_9334.field_49628);
        class_2487 nbtCompound = nbtComponent == null ? null : nbtComponent.method_57461();
        Map<String, Integer> enchantMap = ItemUtils.getData((class_1799)this, CookiesDataComponentTypes.ENCHANTMENTS);
        if (enchantMap != null && itemConvertible.method_8389() == class_1802.field_8598 && enchantMap.size() == 1) {
            Map.Entry<String, Integer> next = enchantMap.entrySet().iterator().next();
            String internal_name = "%s;%s".formatted(next.getKey(), next.getValue()).toUpperCase(Locale.ROOT);
            this.method_57379(CookiesDataComponentTypes.SKYBLOCK_ID, internal_name);
            this.method_57379(CookiesDataComponentTypes.REPOSITORY_ITEM, RepositoryItem.of(internal_name));
        }
        if ((petInfo = (PetInfo)this.method_57824(CookiesDataComponentTypes.PET_INFO)) != null && (repositoryItem = (RepositoryItem)Optional.ofNullable(RepositoryItem.of((s = petInfo.type() + "/") + (ordinal = petInfo.tier().ordinal()))).or(() -> Optional.ofNullable(RepositoryItem.of(s + (ordinal + 1)))).or(() -> Optional.ofNullable(RepositoryItem.of(s + (ordinal - 1)))).orElse(null)) != null) {
            this.method_57379(CookiesDataComponentTypes.REPOSITORY_ITEM, repositoryItem);
            this.method_57379(CookiesDataComponentTypes.SKYBLOCK_ID, repositoryItem.getInternalId());
        }
        this.method_57379(CookiesDataComponentTypes.SELF, (class_1799)this);
        ((ItemStackEvents)ItemStackEvents.EVENT.invoker()).create((class_1799)this);
        if (!ConfigManager.isLoaded()) {
            return;
        }
        this.cookies$setPetLevel(nbtCompound, componentMapImpl);
        this.cookies$setStars();
        class_9290 loreComponent = (class_9290)componentMapImpl.method_57829(class_9334.field_49632);
        if (loreComponent == null || loreComponent.comp_2400() == null || loreComponent.comp_2400().isEmpty()) {
            return;
        }
        List<class_5250> lines = loreComponent.comp_2400().stream().map(class_2561::method_27661).collect(Collectors.toList());
        ((Consumer)ItemLoreEvent.EVENT.invoker()).accept(lines);
        ((ItemLoreEvent)ItemLoreEvent.EVENT_ITEM.invoker()).modify((class_1799)this, lines);
        if (lines.size() != loreComponent.comp_2400().size()) {
            this.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, lines.stream().map(class_2561.class::cast).collect(Collectors.toList()));
        } else {
            for (int index = 0; index < lines.size(); ++index) {
                if (lines.get(index).equals(loreComponent.comp_2400().get(index))) continue;
                this.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, lines.stream().map(class_2561.class::cast).collect(Collectors.toList()));
                break;
            }
        }
    }

    @Unique
    private void cookies$setStars() {
        String slotText;
        if (!MiscCategory.showItemUpgrades) {
            return;
        }
        if (!this.method_57826(CookiesDataComponentTypes.UPGRADE_LEVEL)) {
            return;
        }
        Integer i = (Integer)this.method_57824(CookiesDataComponentTypes.UPGRADE_LEVEL);
        if (i == null) {
            return;
        }
        if (i == 10) {
            slotText = "\u00a74" + i;
        } else if (i > 5) {
            slotText = "\u00a7c" + i;
        } else if (i == 5) {
            slotText = "\u00a76" + i;
        } else if (i >= 1) {
            slotText = "\u00a7e" + i;
        } else {
            return;
        }
        this.method_57379(CookiesDataComponentTypes.CUSTOM_SLOT_TEXT, slotText);
    }

    @Unique
    private void cookies$setComponents() {
        if (((CustomComponentMapAccessor)this.field_49270).cookies$getMergedComponentMap() == null) {
            ((CustomComponentMapAccessor)this.field_49270).cookies$setMergedComponentMap(new class_9335(class_9323.field_49584));
        }
    }

    @Unique
    private <T, D> void cookies$registerType(CookiesDataComponentTypes.DataType<T, D> dataType) {
        for (String key : dataType.key()) {
            if (!this.cookies$performeTest(dataType, key)) continue;
            Object data = this.method_57353().method_57829(dataType.source());
            this.method_57379(dataType.target(), dataType.mapper().apply(data, key));
            break;
        }
    }

    @Shadow
    @Nullable
    public abstract <T> T method_57379(class_9331<? super T> var1, @Nullable T var2);

    @Unique
    private void cookies$setPetLevel(class_2487 nbtCompound, class_9335 componentMapImpl) {
        class_124 tier;
        if (nbtCompound == null) {
            return;
        }
        if (!MiscCategory.showPetLevelAsStackSize) {
            return;
        }
        if (!nbtCompound.method_10545("petInfo")) {
            return;
        }
        class_2561 text = (class_2561)componentMapImpl.method_57829(class_9334.field_49631);
        if (text == null) {
            return;
        }
        String level = text.getString().replaceAll("\\[Lvl (\\d+)].*", "$1");
        if (MiscCategory.showPetRarityInLevelText) {
            JsonObject jsonObject = JsonParser.parseString((String)nbtCompound.method_10558("petInfo")).getAsJsonObject();
            tier = RepositoryItem.Tier.valueOf(jsonObject.get("tier").getAsString()).getFormatting();
        } else {
            tier = class_124.field_1068;
        }
        this.method_57379(CookiesDataComponentTypes.CUSTOM_SLOT_TEXT, tier.toString() + level.replaceAll("\\D", ""));
    }

    @Unique
    private <D, T> boolean cookies$performeTest(CookiesDataComponentTypes.DataType<T, D> dataType, String key) {
        Object data = this.field_49270.method_57829(dataType.source());
        if (data == null) {
            return false;
        }
        return dataType.test().apply(data, key);
    }

    @Shadow
    public abstract class_9323 method_57353();

    @Shadow
    public abstract class_9326 method_57380();

    @Shadow
    public abstract class_2561 method_7964();

    @WrapOperation(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;appendTooltip(Lnet/minecraft/component/ComponentType;Lnet/minecraft/item/Item$TooltipContext;Ljava/util/function/Consumer;Lnet/minecraft/item/tooltip/TooltipType;)V", ordinal=5)})
    private <T> void getLore(class_1799 instance, class_9331<T> componentType, class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, Operation<Void> original) {
        if (!componentType.equals((Object)class_9334.field_49632)) {
            return;
        }
        List<class_2561> data = ItemUtils.getData(instance, CookiesDataComponentTypes.CUSTOM_LORE);
        if (data == null) {
            original.call(new Object[]{instance, componentType, context, textConsumer, type});
            return;
        }
        data.forEach(textConsumer);
    }
}

