/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock;

import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.ForgeRecipe;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class ForgeUtils {
    public static long getStartTimeSeconds(String timeRemaining, RepositoryItem item) {
        if (timeRemaining == null || item == null) {
            return -1L;
        }
        if (item.getRecipes().isEmpty()) {
            return -1L;
        }
        long playerDuration = ForgeUtils.getForgeTime(item);
        long timeRemainingSeconds = ForgeUtils.getTimeRemainingInSeconds(timeRemaining);
        long timePassed = playerDuration - timeRemainingSeconds;
        return System.currentTimeMillis() / 1000L - timePassed;
    }

    public static long getTimeRemainingInSeconds(String timeRemaining) {
        Matcher matcher = Pattern.compile("(?:(\\d+)d ?)?(?:(\\d+)h ?)?(?:(\\d+)m ?)?(?:(\\d+)s)?").matcher(timeRemaining);
        if (!matcher.find()) {
            return -1L;
        }
        long days = ForgeUtils.longOrZero(matcher.group(1));
        long hours = ForgeUtils.longOrZero(matcher.group(2)) + days * 24L;
        long minutes = ForgeUtils.longOrZero(matcher.group(3)) + hours * 60L;
        return ForgeUtils.longOrZero(matcher.group(4)) + minutes * 60L;
    }

    public static long getForgeTime(RepositoryItem repositoryItem) {
        if (repositoryItem == null) {
            return -1L;
        }
        Optional<ForgeRecipe> first = repositoryItem.getRecipes().stream().filter(ForgeRecipe.class::isInstance).map(ForgeRecipe.class::cast).findFirst();
        if (first.isEmpty()) {
            return -1L;
        }
        ForgeRecipe recipe = first.get();
        return recipe.getPlayerDuration();
    }

    private static long longOrZero(String number) {
        return ExceptionHandler.removeThrowsSilent(() -> Long.parseLong(number), 0L);
    }

    @Nullable
    public static String extractTimeRemaining(List<class_2561> lore) {
        for (class_2561 text : lore) {
            String content = text.getString();
            if (!content.startsWith("Time Remaining: ")) continue;
            return content.substring(16);
        }
        return null;
    }
}

