/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock;

import codes.cookies.mod.events.IslandChangeEvent;
import codes.cookies.mod.events.profile.ServerSwapEvent;
import codes.cookies.mod.generated.Regions;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.minecraft.ScoreboardUtils;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.function.Consumer;
import lombok.Generated;
import net.hypixel.data.region.Environment;
import net.hypixel.data.type.GameType;
import net.hypixel.modapi.HypixelModAPI;
import net.hypixel.modapi.packet.impl.clientbound.ClientboundHelloPacket;
import net.hypixel.modapi.packet.impl.clientbound.event.ClientboundLocationPacket;
import net.minecraft.class_2960;

public class LocationUtils {
    private static Regions region;
    private static Island island;
    private static long lastUpdated;
    private static boolean isInSkyblock;
    private static String serverName;
    private static final class_2960 SEND_ISLAND_DEBUG;
    private static boolean isOnHypixelAlpha;

    public static String getLastServer() {
        return serverName;
    }

    public static Optional<String> getServerDisplayName() {
        if (serverName == null) {
            return Optional.empty();
        }
        return Optional.of(serverName.replace("mini", "m").replace("mega", "M"));
    }

    public static void register() {
        HypixelModAPI.getInstance().createHandler(ClientboundLocationPacket.class, LocationUtils::handleLocationUpdate);
        HypixelModAPI.getInstance().createHandler(ClientboundHelloPacket.class, LocationUtils::onJoinHypixel);
    }

    private static void onJoinHypixel(ClientboundHelloPacket clientboundHelloPacket) {
        if (clientboundHelloPacket.getEnvironment() == Environment.BETA) {
            isOnHypixelAlpha = true;
            CookiesUtils.sendFailedMessage("You are on Hypixel Alpha, profile data will not be saved!");
        } else {
            isOnHypixelAlpha = false;
        }
    }

    public static boolean isOnHypixelAlpha() {
        return isOnHypixelAlpha;
    }

    public static boolean isInSkyblock() {
        return isInSkyblock;
    }

    private static void handleLocationUpdate(ClientboundLocationPacket clientboundLocationPacket) {
        GameType game;
        Object t;
        serverName = clientboundLocationPacket.getServerName();
        Optional serverType = clientboundLocationPacket.getServerType();
        if (serverType.isEmpty() || !((t = serverType.get()) instanceof GameType) || (game = (GameType)t) != GameType.SKYBLOCK) {
            isInSkyblock = false;
            LocationUtils.setIsland(Island.NONE);
            return;
        }
        isInSkyblock = true;
        Optional mode = clientboundLocationPacket.getMode();
        if (mode.isEmpty()) {
            LocationUtils.setIsland(Island.UNKNOWN);
        } else {
            LocationUtils.setIsland(Island.parse((String)mode.get()));
        }
        if (DevUtils.isEnabled(SEND_ISLAND_DEBUG)) {
            CookiesUtils.sendMessage(serverName + " " + String.valueOf((Object)island));
        }
        ((ServerSwapEvent)ServerSwapEvent.SERVER_SWAP.invoker()).onServerSwap();
        ((Consumer)ServerSwapEvent.SERVER_SWAP_ID.invoker()).accept(serverName);
    }

    private static void setIsland(Island island) {
        Island previous = LocationUtils.island;
        LocationUtils.island = island;
        ((IslandChangeEvent)IslandChangeEvent.EVENT.invoker()).onIslandChange(previous, island);
    }

    public static Regions getRegion() {
        if (lastUpdated + 1000L > System.currentTimeMillis()) {
            return region;
        }
        SequencedCollection lines = ScoreboardUtils.getLines().reversed();
        String location = null;
        String icon = "";
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("\u23e3 ") && !line.startsWith("\u0444 ")) continue;
            icon = line.trim().substring(0, 1).trim();
            location = line.trim().substring(1).trim();
            break;
        }
        if (location == null) {
            lastUpdated = System.currentTimeMillis();
            region = Regions.UNKNOWN;
            return region;
        }
        for (Regions value : Regions.values()) {
            if (value.icon != null && !icon.equals(value.icon) || (!value.regex || !location.matches(value.scoreboard)) && !location.equals(value.scoreboard)) continue;
            lastUpdated = System.currentTimeMillis();
            region = value;
            return region;
        }
        lastUpdated = System.currentTimeMillis();
        region = Regions.UNKNOWN;
        return region;
    }

    static {
        lastUpdated = -1L;
        SEND_ISLAND_DEBUG = DevUtils.createIdentifier("island_debug");
        isOnHypixelAlpha = false;
    }

    public static enum Island {
        PRIVATE_ISLAND("dynamic"),
        GARDEN("garden"),
        HUB("hub"),
        THE_BARN("farming_1"),
        MUSHROOM_DESERT("farming_1"),
        THE_PARK("foraging_1"),
        SPIDERS_DEN("combat_1"),
        THE_END("combat_3"),
        CRIMSON_ISLE("crimson_isle"),
        GOLD_MINE("mining_1"),
        DEEP_CAVERNS("mining_2"),
        DWARVEN_MINES("mining_3"),
        CRYSTAL_HOLLOWS("crystal_hollows"),
        WINTER_ISLAND("winter"),
        DUNGEON_HUB("dungeon_hub"),
        RIFT("rift"),
        CATACOMBS("dungeon"),
        MINESHAFT("mineshaft"),
        UNKNOWN("*"),
        NONE("");

        private final String apiName;
        private static final Island[] VALUES;
        private static final class_2960 SKIP_ISLAND_CHECK;

        public static Island parse(String apiName) {
            for (Island value : VALUES) {
                if (!value.getApiName().equals(apiName)) continue;
                return value;
            }
            return UNKNOWN;
        }

        public boolean isActive() {
            if (DevUtils.isEnabled(SKIP_ISLAND_CHECK)) {
                return true;
            }
            if (this == THE_BARN || this == MUSHROOM_DESERT) {
                return island == THE_BARN || island == MUSHROOM_DESERT;
            }
            return island == this;
        }

        @Generated
        private Island(String apiName) {
            this.apiName = apiName;
        }

        @Generated
        public String getApiName() {
            return this.apiName;
        }

        static {
            VALUES = Island.values();
            SKIP_ISLAND_CHECK = DevUtils.createIdentifier("islands/skip_check");
        }
    }
}

