/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.utils.cookies.CookiesBackendUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.hypixel.modapi.HypixelModAPI;
import net.hypixel.modapi.packet.HypixelPacket;
import net.hypixel.modapi.packet.impl.clientbound.ClientboundHelloPacket;
import net.hypixel.modapi.packet.impl.clientbound.ClientboundPartyInfoPacket;
import net.hypixel.modapi.packet.impl.serverbound.ServerboundPartyInfoPacket;

public class PartyUtils {
    private static boolean isInParty;
    private static UUID partyLeader;
    private static Set<UUID> partyMembers;
    private static long lastReceived;

    public static void register() {
        HypixelModAPI.getInstance().createHandler(ClientboundPartyInfoPacket.class, PartyUtils::handle);
        HypixelModAPI.getInstance().createHandler(ClientboundHelloPacket.class, packet -> PartyUtils.request());
        CookiesMod.getExecutorService().scheduleAtFixedRate(() -> {
            if (LocationUtils.isInSkyblock()) {
                PartyUtils.request();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    public static void request() {
        if (System.currentTimeMillis() - lastReceived < 2000L) {
            return;
        }
        HypixelModAPI.getInstance().sendPacket((HypixelPacket)new ServerboundPartyInfoPacket());
    }

    private static void handle(ClientboundPartyInfoPacket clientboundPartyInfoPacket) {
        lastReceived = System.currentTimeMillis();
        isInParty = clientboundPartyInfoPacket.isInParty();
        if (isInParty) {
            partyLeader = clientboundPartyInfoPacket.getLeader().orElse(null);
            partyMembers = clientboundPartyInfoPacket.getMemberMap().keySet();
            CookiesBackendUtils.requestUUIDS((UUID[])partyMembers.toArray(UUID[]::new));
        } else {
            partyLeader = null;
            partyMembers = null;
        }
    }

    @Generated
    public static boolean isInParty() {
        return isInParty;
    }

    @Generated
    public static UUID getPartyLeader() {
        return partyLeader;
    }

    @Generated
    public static Set<UUID> getPartyMembers() {
        return partyMembers;
    }
}

