/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock;

import codes.cookies.mod.utils.TextUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.items.types.InventoryUtilsDataComponentTypes;
import codes.cookies.mod.utils.skyblock.InventoryUtils;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import com.google.common.util.concurrent.Runnables;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class SelectSlotInventory {
    private static final class_1799 NOT_ELIGIBLE_FOR_SELECTION = new ItemBuilder(class_1802.field_8077).setLore().hideAdditionalTooltips().setName((class_2561)TextUtils.translatable("cookies.select_slot.not_eligible", class_124.field_1061)).setClickRunnable(Runnables.doNothing()).setGlint(false).build();
    private static final class_1799 ELIGIBLE_FOR_SELECTION = new ItemBuilder(class_1802.field_8157).setLore(new class_2561[]{TextUtils.translatable("cookies.click_to_select", class_124.field_1054).method_27693("!")}).setName((class_2561)TextUtils.translatable("cookies.select_slot.eligible", class_124.field_1060)).hideAdditionalTooltips().setGlint().build();
    private final Predicate<class_1799> selectable;
    private final boolean allowPlayerInventory;
    private final class_1799 eligibleForSelection;
    private final class_1799 notEligibleForSelection;
    private final Consumer<class_1735> selectedSlotCallback;
    private final class_1703 screenHandler;

    public SelectSlotInventory(Predicate<class_1799> selectable, Consumer<class_1735> selectedSlotCallback) {
        this(selectable, false, selectedSlotCallback);
    }

    public SelectSlotInventory(Predicate<class_1799> selectable, boolean allowPlayerInventory, Consumer<class_1735> selectedSlotCallback) {
        this(selectable, allowPlayerInventory, ELIGIBLE_FOR_SELECTION, NOT_ELIGIBLE_FOR_SELECTION, selectedSlotCallback);
    }

    public SelectSlotInventory(Predicate<class_1799> selectable, boolean allowPlayerInventory, class_1799 eligibleForSelection, class_1799 notEligibleForSelection, Consumer<class_1735> selectedSlotCallback) {
        this.selectable = selectable;
        this.allowPlayerInventory = allowPlayerInventory;
        this.eligibleForSelection = eligibleForSelection;
        this.notEligibleForSelection = notEligibleForSelection;
        this.selectedSlotCallback = selectedSlotCallback;
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen == null || !(currentScreen instanceof class_465)) {
            throw new UnsupportedOperationException("The current screen is not a handled inventory");
        }
        class_465 handledScreen = (class_465)currentScreen;
        this.screenHandler = handledScreen.method_17577();
        this.screenHandler.field_7761.forEach(this::updateSlot);
    }

    private void updateSlot(class_1735 slot) {
        if (!this.allowPlayerInventory && slot.field_7871 == class_310.method_1551().field_1724.method_31548()) {
            return;
        }
        class_1799 stack = slot.method_7677();
        if (!this.selectable.test(stack)) {
            class_1799 copy = this.notEligibleForSelection.method_7972();
            copy.method_57379(InventoryUtilsDataComponentTypes.MODIFIED, (Object)true);
            stack.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)copy);
            return;
        }
        stack.method_57381(CookiesDataComponentTypes.OVERRIDE_ITEM);
        class_1799 copy = this.eligibleForSelection.method_7972();
        copy.method_57379(InventoryUtilsDataComponentTypes.MODIFIED, (Object)true);
        copy.method_57379(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, (Object)InventoryUtils.wrapWithSound(this.clickedSlot(slot)));
        slot.method_7677().method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)copy);
    }

    private Runnable clickedSlot(class_1735 slot) {
        return () -> {
            this.cleanSlots();
            this.selectedSlotCallback.accept(slot);
        };
    }

    private void cleanSlots() {
        this.screenHandler.field_7761.forEach(this::cleanSlot);
    }

    private void cleanSlot(class_1735 slot) {
        if (!this.allowPlayerInventory && slot.field_7871 == class_310.method_1551().field_1724.method_31548()) {
            return;
        }
        Boolean data = ItemUtils.getData(slot.method_7677(), InventoryUtilsDataComponentTypes.MODIFIED);
        if (data != null && data.booleanValue()) {
            slot.method_7677().method_57381(CookiesDataComponentTypes.OVERRIDE_ITEM);
        }
    }
}

