/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock;

import java.time.Duration;
import java.time.Instant;
import lombok.Generated;

public class SkyblockDateTime {
    private static final Instant SKYBLOCK_EPOCH = Instant.ofEpochMilli(1560275700000L);
    private final Instant instant;
    private final Instant skyblockInstant;
    private static final long SB_HOUR = 50L;
    private static final long SB_DAY = 1200L;
    private static final long SB_MONTH = 37200L;
    private static final long SB_SEASON = 111600L;
    private static final long SB_YEAR = 446400L;

    public SkyblockDateTime(Instant instant) {
        this.instant = instant;
        this.skyblockInstant = this.instant.minus(Duration.ofSeconds(SKYBLOCK_EPOCH.getEpochSecond()));
    }

    public static SkyblockDateTime ofSkyblockInstant(Instant instant) {
        return new SkyblockDateTime(instant.plus(Duration.ofSeconds(SKYBLOCK_EPOCH.getEpochSecond())));
    }

    public static SkyblockDateTime now() {
        return new SkyblockDateTime(Instant.now());
    }

    public static SkyblockDateTime ofEpochSecond(long second) {
        return new SkyblockDateTime(Instant.ofEpochSecond(second));
    }

    private long getSkyblockInstant() {
        return this.skyblockInstant.getEpochSecond();
    }

    private int getElapsedSkyblockMinutes() {
        return (int)Math.floor((double)this.getSkyblockInstant() / 0.83);
    }

    private int getCurrentSkyblockMinute() {
        return (int)Math.floor((double)(this.getSkyblockInstant() % 50L) / 0.83);
    }

    private int getElapsedSkyblockHours() {
        return (int)Math.floor((float)this.getSkyblockInstant() / 50.0f);
    }

    private int getCurrentSkyblockHour() {
        return (int)Math.floor((float)this.getSkyblockInstant() % 1200.0f / 50.0f);
    }

    private int getElapsedSkyblockDays() {
        return (int)Math.floor((float)this.getSkyblockInstant() / 1200.0f);
    }

    private int getCurrentSkyblockDay() {
        return (int)Math.floor((float)this.getSkyblockInstant() % 37200.0f / 1200.0f) + 1;
    }

    private int getElapsedSkyblockMonths() {
        return (int)Math.floor((float)this.getSkyblockInstant() / 37200.0f);
    }

    private int getCurrentSkyblockMonth() {
        return (int)Math.floor((float)this.getSkyblockInstant() % 446400.0f / 37200.0f) + 1;
    }

    private int getSkyblockYear() {
        return (int)Math.floor((float)this.getSkyblockInstant() / 446400.0f) + 1;
    }

    public boolean isInFuture() {
        SkyblockDateTime now = SkyblockDateTime.now();
        return now.getElapsedSkyblockDays() < this.getElapsedSkyblockDays();
    }

    public boolean isCurrentDay() {
        SkyblockDateTime now = SkyblockDateTime.now();
        return now.getElapsedSkyblockDays() == this.getElapsedSkyblockDays();
    }

    public boolean isInPast() {
        SkyblockDateTime now = SkyblockDateTime.now();
        return now.getElapsedSkyblockDays() > this.getElapsedSkyblockDays();
    }

    public String toString() {
        return "%s:%S %s/%s/%s".formatted(this.getCurrentSkyblockHour(), this.getCurrentSkyblockMinute(), this.getCurrentSkyblockDay(), this.getCurrentSkyblockMonth(), this.getSkyblockYear());
    }

    public String toStringWithEvents() {
        StringBuilder stringBuilder = new StringBuilder();
        for (SkyblockEvents value : SkyblockEvents.values()) {
            if (!this.isActive(value)) continue;
            stringBuilder.append((Object)value).append(", ");
        }
        String suffix = "";
        if (!stringBuilder.isEmpty()) {
            suffix = "[%s]".formatted(stringBuilder.substring(0, stringBuilder.length() - 2));
        }
        return "%s %s".formatted(this.toString(), suffix);
    }

    public SkyblockDateTime withYear(int year) {
        return new SkyblockDateTime(Instant.ofEpochSecond(this.getInstant().getEpochSecond() - (long)this.getSkyblockYear() * 446400L + (long)year * 446400L));
    }

    public SkyblockDateTime withMonth(int month) {
        return new SkyblockDateTime(Instant.ofEpochSecond(this.getInstant().getEpochSecond() - (long)(this.getCurrentSkyblockMonth() - 1) * 37200L + (long)month * 37200L));
    }

    public SkyblockDateTime withDay(int day) {
        return new SkyblockDateTime(Instant.ofEpochSecond(this.getInstant().getEpochSecond() - (long)(this.getCurrentSkyblockDay() - 1) * 1200L + (long)day * 1200L));
    }

    public SkyblockDateTime withMinute(int minute) {
        return new SkyblockDateTime(Instant.ofEpochMilli((long)((double)(this.getInstant().getEpochSecond() - this.getInstant().getEpochSecond() % 50L) + (double)minute * 0.83) * 1000L));
    }

    public SkyblockDateTime withMinuteZero() {
        return new SkyblockDateTime(Instant.ofEpochSecond(this.getInstant().getEpochSecond() - this.getInstant().getEpochSecond() % 50L));
    }

    public SkyblockDateTime withHour(int hour) {
        return new SkyblockDateTime(Instant.ofEpochSecond(this.getInstant().getEpochSecond() - this.getInstant().getEpochSecond() % 1200L + (long)hour * 50L));
    }

    private SkyblockDateTime with(int minute, int hour, int day, int month, int year) {
        return SkyblockDateTime.ofSkyblockInstant(Instant.ofEpochMilli((long)(((double)minute * 0.83 + (double)((long)hour * 50L) + (double)((long)day * 1200L) + (double)((long)month * 37200L) + (double)((long)year * 446400L)) * 1000.0)));
    }

    public boolean isActive(SkyblockEvents events) {
        return switch (events.ordinal()) {
            case 0 -> {
                if (this.getElapsedSkyblockDays() % 3 == 1) {
                    yield true;
                }
                yield false;
            }
            case 10 -> {
                if (this.getElapsedSkyblockDays() % 3 == 0) {
                    yield true;
                }
                yield false;
            }
            case 12 -> {
                if (this.getCurrentSkyblockDay() != 0 && this.getCurrentSkyblockDay() % 7 == 0) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                if (this.getCurrentSkyblockMonth() == 12 && this.getCurrentSkyblockDay() >= 29) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (this.getCurrentSkyblockMonth() == 4 && this.getCurrentSkyblockDay() <= 3 || this.getCurrentSkyblockMonth() == 10 && this.getCurrentSkyblockDay() <= 3) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (this.getCurrentSkyblockMonth() == 8 && this.getCurrentSkyblockDay() >= 29) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                if (this.getCurrentSkyblockMonth() == 12) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                if (this.getCurrentSkyblockMonth() == 12 && this.getCurrentSkyblockDay() >= 24 && this.getCurrentSkyblockDay() <= 26) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.getCurrentSkyblockMonth() == 6 && this.getCurrentSkyblockDay() == 27) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (this.getCurrentSkyblockMonth() == 3 && this.getCurrentSkyblockDay() == 27) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (this.getCurrentSkyblockMonth() < 3 || this.getCurrentSkyblockMonth() == 3 && this.getCurrentSkyblockDay() < 27 || this.getCurrentSkyblockMonth() > 6 || this.getCurrentSkyblockMonth() == 6 && this.getCurrentSkyblockDay() >= 27) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public SkyblockDateTime getNext(SkyblockEvents skyblockEvents) {
        return switch (skyblockEvents.ordinal()) {
            case 0 -> this.with(0, 0, this.getCurrentSkyblockDay() + 3 - this.getCurrentSkyblockDay() % 3 - 1, this.getCurrentSkyblockMonth() - 1, this.getSkyblockYear() - 1);
            case 10 -> this.with(0, 0, this.getCurrentSkyblockDay() + 3 - this.getCurrentSkyblockDay() % 3 - 2, this.getCurrentSkyblockMonth() - 1, this.getSkyblockYear() - 1);
            case 12 -> {
                if (this.getCurrentSkyblockDay() < 27) {
                    yield this.with(0, 0, this.getCurrentSkyblockDay() - this.getCurrentSkyblockDay() % 7 + 6, this.getCurrentSkyblockMonth() - 1, this.getSkyblockYear() - 1);
                }
                yield this.with(0, 0, 6, this.getCurrentSkyblockMonth(), this.getSkyblockYear() - 1);
            }
            case 11 -> {
                if (this.isActive(SkyblockEvents.NEW_YEAR)) {
                    yield this.with(0, 0, 28, 11, this.getSkyblockYear());
                }
                yield this.with(0, 0, 28, 11, this.getSkyblockYear() - 1);
            }
            case 1 -> {
                if (this.getCurrentSkyblockMonth() == 10 && this.getCurrentSkyblockDay() > 3 || this.getCurrentSkyblockMonth() > 10 || this.getCurrentSkyblockMonth() < 3) {
                    yield this.with(0, 0, 0, 2, this.getSkyblockYear());
                }
                yield this.with(0, 0, 0, 9, this.getSkyblockYear());
            }
            case 9 -> {
                if (this.getCurrentSkyblockMonth() == 12) {
                    yield this.with(0, 0, 0, 11, this.getSkyblockYear());
                }
                yield this.with(0, 0, 0, 11, this.getSkyblockYear() - 1);
            }
            case 5 -> {
                if (this.getCurrentSkyblockMonth() < 3 || this.getCurrentSkyblockMonth() == 3 && this.getCurrentSkyblockDay() < 27) {
                    yield this.with(0, 0, 26, 2, this.getSkyblockYear() - 1);
                }
                yield this.with(0, 0, 26, 2, this.getSkyblockYear());
            }
            case 2, 4 -> {
                if (this.getCurrentSkyblockMonth() < 6 || this.getCurrentSkyblockMonth() == 6 && this.getCurrentSkyblockDay() < 27) {
                    yield this.with(0, 0, 26, 5, this.getSkyblockYear() - 1);
                }
                yield this.with(0, 0, 26, 5, this.getSkyblockYear());
            }
            case 8 -> {
                if (this.getCurrentSkyblockMonth() == 12 && this.getCurrentSkyblockDay() >= 24) {
                    yield this.with(0, 0, 23, 11, this.getSkyblockYear());
                }
                yield this.with(0, 0, 23, 11, this.getSkyblockYear() - 1);
            }
            case 3 -> {
                if (this.getCurrentSkyblockMonth() > 8 || this.getCurrentSkyblockMonth() == 8 && this.getCurrentSkyblockDay() >= 29) {
                    yield this.with(0, 0, 28, 7, this.getSkyblockYear());
                }
                yield this.with(0, 0, 28, 7, this.getSkyblockYear() - 1);
            }
            default -> this;
        };
    }

    @Generated
    public Instant getInstant() {
        return this.instant;
    }

    public static enum SkyblockEvents {
        FARMING_CONTEST,
        TRAVELING_ZOO,
        ELECTION_START,
        SPOOKY_FESTIVAL,
        ELECTION_OPEN,
        ELECTION_CLOSE,
        THUNDER,
        RAIN,
        JERRY_WORKSHOP,
        WINTER_ISLAND,
        DARK_AUCTION,
        NEW_YEAR,
        STAR_CULT;

    }
}

