/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock.inventories;

import codes.cookies.mod.translations.TranslationKeys;
import codes.cookies.mod.utils.RenderUtils;
import codes.cookies.mod.utils.accessors.InventoryScreenAccessor;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.skyblock.inventories.InventoryContents;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import codes.cookies.mod.utils.skyblock.inventories.Pagination;
import codes.cookies.mod.utils.skyblock.inventories.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class ClientSideInventory
extends class_437
implements InventoryScreenAccessor,
TranslationKeys {
    protected static final class_1799 outline = new ItemBuilder(class_1802.field_8157).hideAdditionalTooltips().hideTooltips().build();
    private static final class_2960 TEXTURE = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    private static final int BACKGROUND_WIDTH = 176;
    protected final InventoryContents inventoryContents;
    private final int rows;
    private final List<InventoryScreenAccessor.Disabled> disableds = new ArrayList<InventoryScreenAccessor.Disabled>();
    private final int backgroundHeight;
    private final Slot[] slots;
    private final Slot[] playerInventorySlots;
    protected boolean drawBackground = true;
    protected Pagination pagination;
    protected class_2561 inventoryTitle = this.field_22785;
    private int x;
    private int y;

    public ClientSideInventory(class_2561 title, int rows) {
        super(title);
        this.rows = rows;
        this.backgroundHeight = 114 + this.rows * 18;
        this.slots = new Slot[this.rows * 9];
        this.playerInventorySlots = new Slot[36];
        for (int index = 0; index < this.slots.length; ++index) {
            int slotX = index % 9;
            int slotY = index / 9;
            this.slots[index] = new Slot(slotX * 18, slotY * 18);
        }
        class_1661 inventory = class_310.method_1551().field_1724.method_31548();
        for (int i = 0; i < this.playerInventorySlots.length; ++i) {
            int slotX = i % 9;
            int tempY = i / 9 - 1;
            int slotY = tempY < 0 ? tempY + 4 : tempY;
            Slot slot = new Slot(slotX * 18, slotY * 18 + (tempY < 0 ? 4 : 0) + this.rows * 18 + 13);
            slot.itemStack = inventory.method_5438(i);
            this.playerInventorySlots[i] = slot;
        }
        this.inventoryContents = new InventoryContents(this.rows, this);
    }

    public void initPagination(List<class_1799> items, Position from, Position to, List<class_1799> first) {
        this.pagination = new Pagination(items, from, to, first);
    }

    public InventoryContents getContents() {
        return this.inventoryContents;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.inventoryTitle != null) {
            context.method_51439(this.field_22793, this.inventoryTitle, this.x + 8, this.y + 6, -1, false);
        }
        context.method_51448().method_22903();
        int offsetX = this.x + 8;
        int offsetY = this.y + 18;
        context.method_51448().method_46416((float)offsetX, (float)offsetY, 0.0f);
        for (Slot slot : this.slots) {
            this.renderSlot(context, slot, mouseX - offsetX, mouseY - offsetY);
        }
        for (Slot playerInventorySlot : this.playerInventorySlots) {
            this.renderSlot(context, playerInventorySlot, mouseX - offsetX, mouseY - offsetY);
        }
        context.method_51448().method_22909();
    }

    protected void method_25426() {
        super.method_25426();
        this.x = (this.field_22789 - 176) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
    }

    public void method_25393() {
        super.method_25393();
        if (this.pagination != null && this.pagination.isDirty()) {
            this.paginationUpdate();
            this.pagination.setItems(this.inventoryContents);
        }
    }

    protected void paginationUpdate() {
        this.inventoryContents.fillRectangle(this.pagination.getFrom(), this.pagination.getTo(), class_1799.field_8037);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.drawBackground) {
            this.method_52752(context);
        }
        int i = (this.field_22789 - 176) / 2;
        int j = (this.field_22790 - this.backgroundHeight) / 2;
        context.method_25290(class_1921::method_62277, TEXTURE, i, j, 0.0f, 0.0f, 176, this.rows * 18 + 17, 256, 256);
        context.method_25290(class_1921::method_62277, TEXTURE, i, j + this.rows * 18 + 17, 0.0f, 126.0f, 176, 96, 256, 256);
    }

    private void renderSlot(class_332 context, Slot slot, int mouseX, int mouseY) {
        if (slot.itemStack == null || slot.itemStack.method_7960()) {
            return;
        }
        int slotX = slot.x;
        int slotY = slot.y;
        context.method_51427(slot.itemStack, slotX, slotY);
        context.method_51431(this.field_22793, slot.itemStack, slotX, slotY);
        if (mouseX > slotX && mouseX < slotX + 18 && mouseY > slotY && mouseY < slotY + 18) {
            RenderUtils.drawSlotHighlightBack(context, slotX, slotY);
            context.method_51446(class_310.method_1551().field_1772, slot.itemStack, mouseX, mouseY);
            RenderUtils.drawSlotHighlightFront(context, slotX, slotY);
        }
    }

    @Override
    public int cookies$getBackgroundWidth() {
        return 176;
    }

    @Override
    public int cookies$getBackgroundHeight() {
        return this.backgroundHeight;
    }

    @Override
    public int cookies$getX() {
        return this.x;
    }

    @Override
    public int cookies$getY() {
        return this.y;
    }

    @Override
    public List<InventoryScreenAccessor.Disabled> cookies$getDisabled() {
        return this.disableds;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int offsetX = this.x + 8;
        int offsetY = this.y + 18;
        double localX = mouseX - (double)offsetX;
        double localY = mouseY - (double)offsetY;
        if (localX > (double)this.slots[0].x && localX < (double)(this.slots[8].x + 18) && localY > (double)this.slots[0].y && localY < (double)(this.slots[this.slots.length - 1].y + 18)) {
            int slotY;
            int slotX = (int)Math.floor(localX / 18.0);
            int index = slotX + (slotY = (int)Math.floor(localY / 18.0)) * 9;
            if (index < 0 || index >= this.slots.length) {
                return super.method_25402(mouseX, mouseY, button);
            }
            Slot slot = this.slots[index];
            if (slot != null) {
                this.executeClick(slot, button);
            }
        } else if (localX > (double)this.playerInventorySlots[9].x && localX < (double)(this.playerInventorySlots[8].x + 18) && localY > (double)this.playerInventorySlots[9].y && localY < (double)(this.playerInventorySlots[0].y + 18)) {
            int slotY;
            int slotX = (int)Math.floor(localX / 18.0);
            int index = slotX + (slotY = (int)Math.floor((localY - (double)this.playerInventorySlots[9].y) / 18.0)) * 9;
            if (index < 0 || index >= this.playerInventorySlots.length) {
                return super.method_25402(mouseX, mouseY, button);
            }
            Slot slot = this.playerInventorySlots[index];
            if (slot != null) {
                this.executeClick(slot, button);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void executeClick(Slot slot, int button) {
        Runnable runnable;
        class_1799 itemStack = slot.itemStack;
        if (itemStack == null || itemStack.method_7960()) {
            return;
        }
        Consumer<Integer> consumer = ItemUtils.getData(itemStack, CookiesDataComponentTypes.ITEM_CLICK_CONSUMER);
        if (consumer != null) {
            consumer.accept(button);
        }
        if ((runnable = ItemUtils.getData(itemStack, CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE)) != null) {
            runnable.run();
        }
    }

    public void setSlot(int row, int column, class_1799 itemStack) {
        this.slots[row * 9 + column].itemStack = Objects.requireNonNullElse(itemStack, class_1799.field_8037);
    }

    @Generated
    public Slot[] getSlots() {
        return this.slots;
    }

    @Generated
    protected int getX() {
        return this.x;
    }

    @Generated
    protected int getY() {
        return this.y;
    }

    private static class Slot {
        private final int x;
        private final int y;
        private class_1799 itemStack;

        public Slot(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

