/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock.inventories;

import codes.cookies.mod.utils.skyblock.inventories.ClientSideInventory;
import codes.cookies.mod.utils.skyblock.inventories.Position;
import java.util.Optional;
import net.minecraft.class_1799;

public class InventoryContents {
    protected final class_1799[][] items;
    protected final int rows;
    protected final int columns;
    private final ClientSideInventory clientSideInventory;

    public InventoryContents(int rows, ClientSideInventory clientSideInventory) {
        this.clientSideInventory = clientSideInventory;
        this.rows = rows;
        this.columns = 9;
        this.items = new class_1799[this.rows][this.columns];
    }

    public void add(class_1799 item) {
        Optional<Position> position = this.firstEmpty();
        position.ifPresent(value -> this.set((Position)value, item));
    }

    public Optional<Position> firstEmpty() {
        for (int row = 0; row < this.items.length; ++row) {
            for (int column = 0; column < this.items[row].length; ++column) {
                if (!this.get(new Position(row, column)).isEmpty()) continue;
                return Optional.of(new Position(row, column));
            }
        }
        return Optional.empty();
    }

    public void set(Position position, class_1799 item) {
        if (position.row() < 0 || position.row() >= this.rows || position.column() < 0 || position.column() >= this.columns) {
            throw new IllegalArgumentException("Position " + position.row() + "x" + position.column() + " is out of bounds of inventory with size " + this.rows + "x" + this.columns);
        }
        this.items[position.row()][position.column()] = item;
        this.update(position, item);
    }

    public Optional<class_1799> get(Position position) {
        if (position.row() < 0 || position.row() >= this.rows || position.column() < 0 || position.column() >= this.columns) {
            throw new IllegalArgumentException("Position " + position.row() + "x" + position.column() + " is out of bounds of inventory with size " + this.rows + "x" + this.columns);
        }
        return Optional.ofNullable(this.items[position.row()][position.column()]);
    }

    private void update(Position position, class_1799 itemStack) {
        this.clientSideInventory.setSlot(position.row(), position.column(), itemStack);
    }

    public void remove(Position position) {
        if (position.row() < 0 || position.row() >= this.rows || position.column() < 0 || position.column() >= this.columns) {
            throw new IllegalArgumentException("Position " + position.row() + "x" + position.column() + " is out of bounds of inventory with size " + this.rows + "x" + this.columns);
        }
        this.items[position.row()][position.column()] = null;
        this.update(position, null);
    }

    public void fill(class_1799 item) {
        for (int row = 0; row < this.items.length; ++row) {
            for (int column = 0; column < this.items[row].length; ++column) {
                this.set(new Position(row, column), item);
            }
        }
    }

    public class_1799[][] items() {
        return this.items;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public void fillRow(int row, class_1799 item) {
        for (int column = 0; column < this.columns; ++column) {
            this.set(new Position(row, column), item);
        }
    }

    public void fillColumn(int column, class_1799 item) {
        for (int row = 0; row < this.rows; ++row) {
            this.set(new Position(row, column), item);
        }
    }

    public void fillBorders(class_1799 item) {
        this.fillRow(0, item);
        this.fillRow(this.rows - 1, item);
        this.fillColumn(0, item);
        this.fillColumn(this.columns - 1, item);
    }

    public void fillRectangle(Position from, Position to, class_1799 item) {
        for (int row = from.row(); row <= to.row(); ++row) {
            for (int column = from.column(); column <= to.column(); ++column) {
                this.set(new Position(row, column), item);
            }
        }
    }
}

