/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock.inventories;

import codes.cookies.mod.utils.TextUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class ItemBuilder {
    private static final String SKIN_DECODED_TEMPLATE = "{\"textures\":{\"SKIN\":{\"url\":\"%S\"}}}";
    private final class_1799 itemStack;

    public ItemBuilder(class_1799 itemStack) {
        this.itemStack = itemStack.method_7972();
    }

    public ItemBuilder(class_1792 item) {
        this.itemStack = new class_1799((class_1935)item);
    }

    public ItemBuilder setName(String name) {
        return this.setName((class_2561)TextUtils.literal(name));
    }

    public ItemBuilder setName(class_2561 name) {
        this.itemStack.method_57379(class_9334.field_49631, (Object)name);
        this.itemStack.method_57379(class_9334.field_50239, (Object)name);
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        return this.setLore((class_2561[])Arrays.stream(lore).map(TextUtils::literal).toArray(class_5250[]::new));
    }

    public ItemBuilder setLore(class_2561 ... lore) {
        this.itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, Arrays.asList(lore));
        this.itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(Arrays.asList(lore), Arrays.asList(lore)));
        return this;
    }

    public ItemBuilder hideTooltips() {
        this.itemStack.method_57379(class_9334.field_50074, (Object)class_3902.field_17274);
        return this;
    }

    public ItemBuilder hideAdditionalTooltips() {
        this.itemStack.method_57379(class_9334.field_49638, (Object)class_3902.field_17274);
        return this;
    }

    public ItemBuilder setLore() {
        this.itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, Collections.emptyList());
        return this;
    }

    public ItemBuilder setGlint() {
        return this.setGlint(true);
    }

    public ItemBuilder setGlint(boolean hasGlint) {
        this.itemStack.method_57379(class_9334.field_49641, (Object)hasGlint);
        return this;
    }

    public ItemBuilder setClickRunnable(Runnable runnable) {
        this.itemStack.method_57379(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, (Object)runnable);
        return this;
    }

    public ItemBuilder setClickConsumer(Consumer<Integer> consumer) {
        this.itemStack.method_57379(CookiesDataComponentTypes.ITEM_CLICK_CONSUMER, consumer);
        return this;
    }

    public ItemBuilder setSkinUrl(String skin) {
        return this.setSkin(Base64.getEncoder().encodeToString(SKIN_DECODED_TEMPLATE.formatted(skin.toLowerCase()).getBytes(StandardCharsets.UTF_8)));
    }

    public ItemBuilder setSkin(String skin) {
        class_9296 component = new class_9296(new GameProfile(UUID.randomUUID(), "meowora"));
        component.comp_2412().put((Object)"textures", (Object)new Property("textures", skin));
        return this.set(class_9334.field_49617, component);
    }

    public <T> ItemBuilder set(class_9331<T> componentType, T value) {
        this.itemStack.method_57379(componentType, value);
        return this;
    }

    public class_1799 build() {
        return this.itemStack.method_7972();
    }

    public ItemBuilder appendLore(class_2561 ... text) {
        for (class_2561 text1 : text) {
            this.appendLore(text1);
        }
        return this;
    }

    public ItemBuilder appendLore(class_2561 text) {
        List texts = Optional.ofNullable((List)this.itemStack.method_57824(CookiesDataComponentTypes.CUSTOM_LORE)).map(ArrayList::new).orElseGet(ArrayList::new);
        if (texts.isEmpty()) {
            return this.setLore(text);
        }
        texts.add(text);
        return this.setLore((class_2561[])texts.toArray(class_2561[]::new));
    }
}

