/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock.inventories;

import codes.cookies.mod.utils.skyblock.inventories.InventoryContents;
import codes.cookies.mod.utils.skyblock.inventories.Position;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_1799;

public class Pagination {
    private final List<class_1799> items;
    private final Position from;
    private final Position to;
    private final List<class_1799> firstItems;
    private int columns;
    private int rows;
    private int maxPage;
    private int currentPage = 1;
    private int firstItemSize;
    private boolean isDirty;

    public Pagination(List<class_1799> items, Position from, Position to, List<class_1799> firstItems) {
        this.items = new ArrayList<class_1799>(items);
        this.from = from;
        this.to = to;
        this.firstItems = Optional.ofNullable(firstItems).orElse(Collections.emptyList());
        this.update();
    }

    public void nextPage() {
        if (this.currentPage < this.maxPage) {
            ++this.currentPage;
            this.isDirty = true;
        }
    }

    public void previousPage() {
        if (this.currentPage > 1) {
            --this.currentPage;
            this.isDirty = true;
        }
    }

    public void setItems(InventoryContents contents) {
        for (int i = 0; i < this.rows * this.columns && i + this.rows * this.columns * (this.currentPage - 1) - this.firstItemSize < this.items.size(); ++i) {
            if (this.currentPage == 1 && !this.firstItems.isEmpty() && this.firstItemSize < i) {
                contents.set(this.from, this.firstItems.get(i));
                continue;
            }
            class_1799 item = this.items.get(i + this.rows * this.columns * (this.currentPage - 1) - this.firstItemSize);
            contents.set(this.from.add(new Position(i / this.columns, i % this.columns)), item);
        }
        this.isDirty = false;
    }

    public void update() {
        this.rows = Math.max(this.from.row(), this.to.row()) - Math.min(this.from.row(), this.to.row()) + 1;
        this.columns = Math.max(this.from.column(), this.to.column()) - Math.min(this.from.column(), this.to.column()) + 1;
        this.maxPage = (this.items.size() + this.firstItems.size()) / (this.rows * this.columns) + 1;
        this.firstItemSize = this.firstItems.size();
        this.isDirty = true;
    }

    public void removeItem(class_1799 item) {
        this.items.remove(item);
        this.update();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean hasPreviousPage() {
        return this.currentPage > 1;
    }

    public boolean hasNextPage() {
        return this.currentPage < this.maxPage;
    }

    @Generated
    public Position getFrom() {
        return this.from;
    }

    @Generated
    public Position getTo() {
        return this.to;
    }

    @Generated
    public int getMaxPage() {
        return this.maxPage;
    }

    @Generated
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Generated
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }
}

