/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock.playerlist;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.events.PlayerListEvent;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.skyblock.playerlist.PlayerListEntrySet;
import codes.cookies.mod.utils.skyblock.playerlist.PlayerListReader;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.PlayerListWidget;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.PlayerListWidgets;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.class_640;

public class PlayerListUtils {
    private static final PlayerListEntrySet playerListEntrySet = new PlayerListEntrySet();
    public static List<PlayerListWidget> widgets = new CopyOnWriteArrayList<PlayerListWidget>();

    public static void init() {
        PlayerListEvent.EVENT.register(PlayerListUtils::update);
        CookiesMod.getExecutorService().scheduleAtFixedRate(PlayerListUtils::updatePlayerListWidgets, 1L, 1L, TimeUnit.SECONDS);
    }

    private static void updatePlayerListWidgets() {
        try {
            if (!SkyblockUtils.isCurrentlyInSkyblock()) {
                return;
            }
            PlayerListReader playerListReader = new PlayerListReader(playerListEntrySet.getInfoElements());
            List<PlayerListWidget> playerListWidgets = PlayerListWidgets.extractAll(playerListReader);
            widgets.clear();
            widgets.addAll(playerListWidgets);
            widgets.forEach(PlayerListWidget::sendEvent);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
    }

    private static void update(class_640 playerListEntry) {
        if (playerListEntry == null) {
            return;
        }
        String name = playerListEntry.method_2966().getName();
        if (!name.startsWith("!")) {
            return;
        }
        if (playerListEntry.method_2971() == null) {
            return;
        }
        playerListEntrySet.replace(PlayerListUtils.getColumn(playerListEntry), PlayerListUtils.getRow(playerListEntry), playerListEntry.method_2971().getString());
    }

    public static boolean isInRange(class_640 entry, int column, int start, int end) {
        return PlayerListUtils.getColumn(entry) == column && PlayerListUtils.getRow(entry) > start && PlayerListUtils.getRow(entry) < end;
    }

    public static Predicate<class_640> isInColumn(int column) {
        return entry -> PlayerListUtils.getColumn(entry) == column;
    }

    public static int getRow(class_640 entry) {
        return entry.method_2966().getName().charAt(3) - 97;
    }

    public static int getColumn(class_640 entry) {
        return entry.method_2966().getName().charAt(1) - 65;
    }
}

