/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock.playerlist.widgets;

import codes.cookies.mod.utils.skyblock.playerlist.PlayerListReader;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.PlayerListWidget;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.corpse.FrozenCorpseWidget;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.crystal.CrystalWidget;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.powder.PowderWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class PlayerListWidgets {
    private static final List<Entry<?>> WIDGETS = new ArrayList();
    public static Entry<FrozenCorpseWidget> CORPSE = PlayerListWidgets.register(FrozenCorpseWidget::doesMatch, FrozenCorpseWidget::new, FrozenCorpseWidget.class);
    public static Entry<CrystalWidget> CRYSTAL = PlayerListWidgets.register(CrystalWidget::doesMatch, CrystalWidget::new, CrystalWidget.class);
    public static Entry<PowderWidget> POWDER = PlayerListWidgets.register(PowderWidget::doesMatch, PowderWidget::new, PowderWidget.class);

    private static <T extends PlayerListWidget> Entry<T> register(Predicate<String> predicate, Supplier<T> creator, Class<T> clazz) {
        Entry<T> entry = new Entry<T>(predicate, creator, clazz);
        WIDGETS.add(entry);
        return entry;
    }

    public static List<PlayerListWidget> extractAll(PlayerListReader playerListReader) {
        ArrayList<PlayerListWidget> widgets = new ArrayList<PlayerListWidget>();
        while (playerListReader.canRead()) {
            if (!playerListReader.isTitle()) {
                playerListReader.skip();
                continue;
            }
            Optional<PlayerListWidget> byTitle = PlayerListWidgets.getByTitle(playerListReader.read());
            byTitle.ifPresent(widget -> {
                widget.read(playerListReader);
                widgets.add((PlayerListWidget)widget);
            });
        }
        return widgets;
    }

    private static Optional<PlayerListWidget> getByTitle(String title) {
        return WIDGETS.stream().filter(entry -> entry.predicate().test(title)).findFirst().map(entry -> (PlayerListWidget)entry.creator.get());
    }

    public record Entry<T extends PlayerListWidget>(Predicate<String> predicate, Supplier<T> creator, Class<T> clazz) {
    }
}

