/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock.playerlist.widgets.corpse;

import codes.cookies.mod.utils.skyblock.playerlist.PlayerListReader;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.PlayerListWidget;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.corpse.CorpseEntry;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.corpse.CorpseType;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class FrozenCorpseWidget
extends PlayerListWidget {
    private final List<CorpseEntry> corpses = new ArrayList<CorpseEntry>();

    public static String getTitle() {
        return "Frozen Corpses";
    }

    public static boolean doesMatch(String s) {
        return s.startsWith(FrozenCorpseWidget.getTitle());
    }

    @Override
    protected void read(PlayerListReader reader) {
        int amount = 0;
        while (reader.canRead() && !reader.peek().isBlank() && !reader.isTitle()) {
            if (!this.addCorpse(reader.peek())) {
                return;
            }
            if (amount > 5) {
                return;
            }
            ++amount;
            reader.skip();
        }
    }

    private boolean addCorpse(String peek) {
        if (!peek.contains(":")) {
            return false;
        }
        String[] parts = peek.split(":");
        if (parts.length != 2) {
            return false;
        }
        if (!"looted".equalsIgnoreCase(parts[1].trim()) && !"not looted".equalsIgnoreCase(parts[1].trim())) {
            return false;
        }
        CorpseType corpseType = CorpseType.getCorpseTypeFromString(parts[0].trim());
        boolean found = "looted".equalsIgnoreCase(parts[1].trim());
        this.corpses.add(new CorpseEntry(corpseType, found));
        return true;
    }

    @Generated
    public List<CorpseEntry> getCorpses() {
        return this.corpses;
    }
}

