/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock.playerlist.widgets.crystal;

import codes.cookies.mod.data.mining.crystal.CrystalStatus;
import codes.cookies.mod.data.mining.crystal.CrystalType;
import codes.cookies.mod.utils.skyblock.playerlist.PlayerListReader;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.PlayerListWidget;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.crystal.CrystalEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class CrystalWidget
extends PlayerListWidget {
    private final List<CrystalEntry> crystals = new ArrayList<CrystalEntry>();
    private boolean showNucleusCrystals = false;
    private boolean showJasperAndRubyCrystals = false;
    private boolean showGlaciteCrystals = false;

    public static boolean doesMatch(String title) {
        return "crystals:".equalsIgnoreCase(title);
    }

    @Override
    protected void read(PlayerListReader reader) {
        while (reader.canRead() && !reader.isTitle()) {
            Optional<CrystalEntry> entryFromString = CrystalEntry.createEntryFromString(reader.read());
            if (entryFromString.isEmpty()) {
                return;
            }
            CrystalEntry crystalEntry = entryFromString.get();
            this.crystals.add(crystalEntry);
            switch (crystalEntry.type().getCrystalOrigin()) {
                case CRYSTAL_HOLLOWS: {
                    this.showNucleusCrystals = true;
                    break;
                }
                case MISC: {
                    this.showJasperAndRubyCrystals = true;
                    break;
                }
                case CRIMSON_ISLE: 
                case GLACITE_TUNNELS: {
                    this.showGlaciteCrystals = true;
                }
            }
        }
    }

    public Optional<CrystalStatus> getCrystalStatusByType(CrystalType crystalType) {
        return this.crystals.stream().filter(crystalEntry -> crystalEntry.type() == crystalType).map(CrystalEntry::status).findFirst();
    }

    public boolean doesShowNucleusCrystals() {
        return this.showNucleusCrystals;
    }

    public boolean doesShowJasperAndRubyCrystals() {
        return this.showJasperAndRubyCrystals;
    }

    public boolean doesShowGlaciteCrystals() {
        return this.showGlaciteCrystals;
    }

    @Generated
    public List<CrystalEntry> getCrystals() {
        return this.crystals;
    }
}

