/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.utils.skyblock.playerlist.widgets.powder;

import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.skyblock.playerlist.PlayerListReader;
import codes.cookies.mod.utils.skyblock.playerlist.widgets.PlayerListWidget;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class PowderWidget
extends PlayerListWidget {
    private static final int MAX_SIZE = 3;
    private OptionalInt mithrilPowder = OptionalInt.empty();
    private OptionalInt gemstonePowder = OptionalInt.empty();
    private OptionalInt glacitePowder = OptionalInt.empty();

    public static boolean doesMatch(String title) {
        return "powders:".equalsIgnoreCase(title);
    }

    @Override
    protected void read(PlayerListReader reader) {
        CompletableFuture<Integer> mithrilReference = new CompletableFuture<Integer>();
        mithrilReference.whenComplete((integer, throwable) -> {
            this.mithrilPowder = OptionalInt.of(integer);
        });
        CompletableFuture<Integer> gemstoneReference = new CompletableFuture<Integer>();
        gemstoneReference.whenComplete((integer, throwable) -> {
            this.gemstonePowder = OptionalInt.of(integer);
        });
        CompletableFuture<Integer> glaciteReference = new CompletableFuture<Integer>();
        glaciteReference.whenComplete((integer, throwable) -> {
            this.glacitePowder = OptionalInt.of(integer);
        });
        for (int currentIteration = 0; reader.canRead() && !reader.isTitle() && currentIteration < 3; ++currentIteration) {
            this.tryParse(mithrilReference, "mithril", reader);
            this.tryParse(gemstoneReference, "gemstone", reader);
            this.tryParse(glaciteReference, "glacite", reader);
        }
    }

    private void tryParse(CompletableFuture<Integer> powderReference, String prefix, PlayerListReader reader) {
        String peek = reader.peek().trim().toLowerCase();
        if (!peek.startsWith(prefix)) {
            return;
        }
        reader.skip();
        String literalPowderAmount = peek.replaceAll("\\D", "");
        int powderAmount = CookiesUtils.parseIntSafe(literalPowderAmount);
        powderReference.complete(powderAmount);
    }

    @Generated
    public OptionalInt getMithrilPowder() {
        return this.mithrilPowder;
    }

    @Generated
    public OptionalInt getGemstonePowder() {
        return this.gemstonePowder;
    }

    @Generated
    public OptionalInt getGlacitePowder() {
        return this.glacitePowder;
    }
}

