/*
 * Decompiled with CFR 0.152.
 */
package dev.morazzer.cookies.entities.websocket;

import dev.morazzer.cookies.entities.websocket.Packet;
import dev.morazzer.cookies.entities.websocket.PacketSerializer;
import dev.morazzer.cookies.entities.websocket.RegisteredPacket;
import dev.morazzer.cookies.entities.websocket.packets.DisconnectPacket;
import dev.morazzer.cookies.entities.websocket.packets.DungeonJoinPacket;
import dev.morazzer.cookies.entities.websocket.packets.DungeonLeavePacket;
import dev.morazzer.cookies.entities.websocket.packets.DungeonMimicKilledPacket;
import dev.morazzer.cookies.entities.websocket.packets.DungeonSyncPlayerLocation;
import dev.morazzer.cookies.entities.websocket.packets.DungeonUpdateRoomIdPacket;
import dev.morazzer.cookies.entities.websocket.packets.DungeonUpdateRoomSecrets;
import dev.morazzer.cookies.entities.websocket.packets.HandshakePacket;
import dev.morazzer.cookies.entities.websocket.packets.TestServerPacket;
import dev.morazzer.cookies.entities.websocket.packets.WrongProtocolVersionPacket;
import dev.morazzer.cookies.entities.websocket.packets.c2s.PlayersUseModRequestPacket;
import dev.morazzer.cookies.entities.websocket.packets.s2c.PlayersUseModResponsePacket;
import java.io.IOException;
import java.util.HashSet;
import java.util.function.Function;

public enum Side {
    PACKETS(Side.register(HandshakePacket.class, HandshakePacket::new), Side.register(DisconnectPacket.class, DisconnectPacket::new), Side.register(WrongProtocolVersionPacket.class, WrongProtocolVersionPacket::new), Side.register(TestServerPacket.class, TestServerPacket::new), Side.register(DungeonJoinPacket.class, DungeonJoinPacket::new), Side.register(DungeonSyncPlayerLocation.class, DungeonSyncPlayerLocation::new), Side.register(DungeonUpdateRoomSecrets.class, DungeonUpdateRoomSecrets::new), Side.register(DungeonUpdateRoomIdPacket.class, DungeonUpdateRoomIdPacket::new), Side.register(DungeonMimicKilledPacket.class, DungeonMimicKilledPacket::new), Side.register(DungeonLeavePacket.class, DungeonLeavePacket::new), Side.register(PlayersUseModResponsePacket.class, PlayersUseModResponsePacket::new), Side.register(PlayersUseModRequestPacket.class, PlayersUseModRequestPacket::new));

    private final RegisteredPacket<?>[] register;
    public static final Side[] VALUES;

    @SafeVarargs
    private Side(Function<Integer, RegisteredPacket<?>> ... register) {
        HashSet registeredPackets = new HashSet();
        this.register = new RegisteredPacket[register.length];
        for (int i = 0; i < register.length; ++i) {
            RegisteredPacket<?> apply = register[i].apply(i);
            if (registeredPackets.contains(apply.getClazz())) {
                throw new IllegalStateException("Duplicate packet registered for " + String.valueOf(apply.getClazz()));
            }
            registeredPackets.add(apply.getClazz());
            this.register[i] = apply;
        }
    }

    public byte[] serializeUnknown(Packet<?> unknown) {
        try {
            RegisteredPacket<?> registeredPacket = this.findForUnknown(unknown);
            PacketSerializer packetSerializer = new PacketSerializer();
            byte[] serialize = registeredPacket.serializeUnknown(unknown);
            packetSerializer.writeInt(registeredPacket.getId());
            packetSerializer.writeByteArrayWithoutLength(serialize);
            return packetSerializer.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while serializing packet " + unknown.getClass().getSimpleName(), e);
        }
    }

    public <T extends Packet<T>> byte[] serialize(T packet) {
        return this.serializeUnknown(packet);
    }

    public <T extends Packet<T>> T deserialize(byte[] packet) throws IOException {
        PacketSerializer packetSerializer = new PacketSerializer(packet);
        int id = packetSerializer.readInt();
        RegisteredPacket<T> deserializer = this.findFor(id);
        if (deserializer == null) {
            throw new RuntimeException("Unknown packet id " + id);
        }
        try {
            T createdPacket = deserializer.deserialize(packetSerializer);
            packetSerializer.ensureEmpty();
            return createdPacket;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while deserializing packet " + deserializer.getClazz().getSimpleName(), e);
        }
    }

    public <T extends Packet<T>> void deserializeAndSend(byte[] packet) throws IOException {
        Packet.receive(this.deserialize(packet));
    }

    private <T extends Packet<T>> RegisteredPacket<T> findFor(int id) {
        for (RegisteredPacket<?> registeredPacket : this.register) {
            if (registeredPacket.getId() != id) continue;
            return registeredPacket;
        }
        return null;
    }

    private RegisteredPacket<?> findForUnknown(Packet<?> packet) {
        for (RegisteredPacket<?> registeredPacket : this.register) {
            if (!registeredPacket.getClazz().isInstance(packet)) continue;
            return registeredPacket;
        }
        return null;
    }

    private static <T extends Packet<T>> Function<Integer, RegisteredPacket<?>> register(Class<T> tClass, RegisteredPacket.PacketCreator<T> packetCreator) {
        return id -> new RegisteredPacket(tClass, packetCreator, (int)id);
    }

    static {
        VALUES = Side.values();
    }
}

