/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.golden_apple_tree.block;

import com.skniro.golden_apple_tree.block.init.LeafCropBlock;
import com.skniro.golden_apple_tree.item.AppleItems;
import com.skniro.golden_apple_tree.world.Tree.AppleSaplingGenerator;
import com.skniro.golden_apple_tree.world.Tree.EnchantedGoldenAppleSaplingGenerator;
import com.skniro.golden_apple_tree.world.Tree.GoldenAppleSaplingGenerator;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class GoldenAppleTreeBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"golden_apple_tree");
    public static final Supplier<Block> Golden_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlock("golden_apple_sapling", () -> new SaplingBlock(GoldenAppleSaplingGenerator.GoldenAppleSapling, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final Supplier<Block> ENCHANTED_GOLDEN_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlock("enchanted_golden_apple_sapling", () -> new SaplingBlock(EnchantedGoldenAppleSaplingGenerator.EnchantedGoldenAppleSapling, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final Supplier<Block> APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlock("apple_sapling", () -> new SaplingBlock(AppleSaplingGenerator.AppleSapling, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final Supplier<Block> Golden_APPLE_LEAVES = GoldenAppleTreeBlocks.registerBlock("golden_apple_leave", () -> new LeafCropBlock(BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER), Items.GOLDEN_APPLE));
    public static final Supplier<Block> ENCHANTED_GOLDEN_APPLE_LEAVES = GoldenAppleTreeBlocks.registerBlock("enchanted_golden_apple_leave", () -> new LeafCropBlock(BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER), Items.ENCHANTED_GOLDEN_APPLE));
    public static final Supplier<Block> APPLE_LEAVES = GoldenAppleTreeBlocks.registerBlock("apple_leave", () -> new LeafCropBlock(BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER), Items.APPLE));
    public static final Supplier<Block> Apple_Tree_LEAVES = GoldenAppleTreeBlocks.registerBlock("apple_tree_leave", () -> new LeavesBlock(BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER)));
    public static final Supplier<Block> POTTED_Golden_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlockWithoutItem("potted_haste_apple_sapling", () -> new FlowerPotBlock(Golden_APPLE_SAPLING.get(), BlockBehaviour.Properties.of().instabreak().noOcclusion()));
    public static final Supplier<Block> POTTED_ENCHANTED_GOLDEN_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlockWithoutItem("potted_enchanted_golden_apple_sapling", () -> new FlowerPotBlock(ENCHANTED_GOLDEN_APPLE_SAPLING.get(), BlockBehaviour.Properties.of().instabreak().noOcclusion()));
    public static final Supplier<Block> POTTED_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlockWithoutItem("potted_apple_sapling", () -> new FlowerPotBlock(APPLE_SAPLING.get(), BlockBehaviour.Properties.of().instabreak().noOcclusion()));

    private static <T extends Block> Supplier<T> registerBlockWithoutItem(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        return toReturn;
    }

    private static <T extends Block> Supplier<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        GoldenAppleTreeBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> Supplier<Item> registerBlockItem(String name, Supplier<T> block) {
        return AppleItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void registerGoldenAppleTreeBlocks(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

