/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.golden_apple_tree.event;

import com.skniro.golden_apple_tree.block.init.LeafCropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class GoldenAppleDispenserBehaviors {
    public static void register() {
        DispenserBlock.registerBehavior((ItemLike)Items.SHEARS, (DispenseItemBehavior)new ShearsDispenserBehavior());
    }

    private static class ShearsDispenserBehavior
    extends DefaultDispenseItemBehavior {
        private ShearsDispenserBehavior() {
        }

        protected ItemStack execute(BlockSource source, ItemStack stack) {
            BlockState state;
            BlockPos targetPos;
            ServerLevel world = source.level();
            if (ShearsDispenserBehavior.tryShearBlock(world, targetPos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING)), state = world.getBlockState(targetPos), stack)) {
                return stack;
            }
            return super.execute(source, stack);
        }

        private static boolean tryShearBlock(ServerLevel world, BlockPos pos, BlockState state, ItemStack stack) {
            Block block = state.getBlock();
            if (block instanceof LeafCropBlock) {
                LeafCropBlock leafCrop = (LeafCropBlock)block;
                int age = (Integer)state.getValue((Property)LeafCropBlock.AGE);
                if (age > 1) {
                    world.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                    Block.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)leafCrop.fruitItem, 1));
                    BlockState newState = (BlockState)state.setValue((Property)LeafCropBlock.AGE, (Comparable)Integer.valueOf(1));
                    world.setBlock(pos, newState, 2);
                    world.gameEvent(null, (Holder)GameEvent.SHEAR, pos);
                    stack.hurtAndBreak(1, world, null, item -> {});
                    return true;
                }
            }
            return false;
        }
    }
}

