/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.golden_apple_tree.block;

import com.skniro.golden_apple_tree.block.init.LeafCropBlock;
import com.skniro.golden_apple_tree.item.AppleItems;
import com.skniro.golden_apple_tree.world.Tree.AppleSaplingGenerator;
import com.skniro.golden_apple_tree.world.Tree.EnchantedGoldenAppleSaplingGenerator;
import com.skniro.golden_apple_tree.world.Tree.GoldenAppleSaplingGenerator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class GoldenAppleTreeBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"golden_apple_tree");
    public static final Supplier<Block> Golden_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlock("golden_apple_sapling", settings -> new SaplingBlock(GoldenAppleSaplingGenerator.GoldenAppleSapling, settings), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final Supplier<Block> ENCHANTED_GOLDEN_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlock("enchanted_golden_apple_sapling", settings -> new SaplingBlock(EnchantedGoldenAppleSaplingGenerator.EnchantedGoldenAppleSapling, settings), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final Supplier<Block> APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlock("apple_sapling", settings -> new SaplingBlock(AppleSaplingGenerator.AppleSapling, settings), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final Supplier<Block> Golden_APPLE_LEAVES = GoldenAppleTreeBlocks.registerBlock("golden_apple_leave", settings -> new LeafCropBlock((BlockBehaviour.Properties)settings, Items.GOLDEN_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final Supplier<Block> ENCHANTED_GOLDEN_APPLE_LEAVES = GoldenAppleTreeBlocks.registerBlock("enchanted_golden_apple_leave", settings -> new LeafCropBlock((BlockBehaviour.Properties)settings, Items.ENCHANTED_GOLDEN_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final Supplier<Block> APPLE_LEAVES = GoldenAppleTreeBlocks.registerBlock("apple_leave", settings -> new LeafCropBlock((BlockBehaviour.Properties)settings, Items.APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final Supplier<Block> Apple_Tree_LEAVES = GoldenAppleTreeBlocks.registerBlock("apple_tree_leave", LeavesBlock::new, BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final Supplier<Block> POTTED_Golden_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlockWithoutItem("potted_haste_apple_sapling", settings -> new FlowerPotBlock(Golden_APPLE_SAPLING.get(), settings), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final Supplier<Block> POTTED_ENCHANTED_GOLDEN_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlockWithoutItem("potted_enchanted_golden_apple_sapling", settings -> new FlowerPotBlock(ENCHANTED_GOLDEN_APPLE_SAPLING.get(), settings), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final Supplier<Block> POTTED_APPLE_SAPLING = GoldenAppleTreeBlocks.registerBlockWithoutItem("potted_apple_sapling", settings -> new FlowerPotBlock(APPLE_SAPLING.get(), settings), BlockBehaviour.Properties.of().instabreak().noOcclusion());

    private static <B extends Block> DeferredBlock<B> registerBlock(String name, Function<BlockBehaviour.Properties, ? extends B> block, BlockBehaviour.Properties properties) {
        DeferredBlock<? extends B> bDeferredBlock = GoldenAppleTreeBlocks.registerBlockWithoutItem(name, block, properties);
        GoldenAppleTreeBlocks.registerBlockItem(name, bDeferredBlock);
        return bDeferredBlock;
    }

    private static <B extends Block> DeferredBlock<B> registerBlockWithoutItem(String name, Function<BlockBehaviour.Properties, ? extends B> block, BlockBehaviour.Properties properties) {
        DeferredBlock register = BLOCKS.registerBlock(name, block, properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"golden_apple_tree", (String)name))));
        return register;
    }

    private static <B extends Block> DeferredBlock<B> registerBlockWithoutItemWithEmpty(String name, Function<BlockBehaviour.Properties, ? extends B> block, BlockBehaviour.Properties properties) {
        DeferredBlock<? extends B> register = GoldenAppleTreeBlocks.registerBlockWithoutItem(name, block, properties);
        return register;
    }

    private static <T extends Block> Holder<Item> registerBlockItem(String name, DeferredBlock<T> block) {
        return AppleItems.ITEMS.registerItem(name, properties -> new BlockItem((Block)block.get(), new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"golden_apple_tree", (String)name)))));
    }

    public static void registerGoldenAppleTreeBlocks(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

