/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.block;

import dev.protomanly.pmweather.config.ClientConfig;
import dev.protomanly.pmweather.event.GameBusClientEvents;
import dev.protomanly.pmweather.util.Util;
import dev.protomanly.pmweather.weather.WeatherProperties;
import dev.protomanly.pmweather.weather.WindEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MetarBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    protected MetarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = super.getStateForPlacement(context);
        if (blockstate == null) {
            blockstate = this.defaultBlockState();
        }
        return (BlockState)blockstate.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            String strForFormat = "Wind: %s\u00b0 @ %s MPH\nTemp: %s\u00b0F\nDew: %s\u00b0F\nRisk: %s";
            Vec3 wind = WindEngine.getWind(pos, level);
            int windAngle = Math.floorMod((int)Math.toDegrees(Math.atan2(wind.x, -wind.z)), 360);
            double windspeed = wind.length();
            WeatherProperties.Properties props = WeatherProperties.getTemperature(GameBusClientEvents.weatherHandler, level, pos);
            float temperature = props.temperature();
            float dew = props.dewpoint();
            if (ClientConfig.metric) {
                strForFormat = "Wind: %s\u00b0 @ %s km/h\nTemp: %s\u00b0C\nDew: %s\u00b0C\nRisk: %s";
                windspeed *= 1.609;
            } else {
                temperature = Util.celsiusToFahrenheit(temperature);
                dew = Util.celsiusToFahrenheit(dew);
            }
            String risk = "NONE (0/6)";
            if (props.risk() > 1.5f) {
                risk = "HIGH (6/6)";
            } else if (props.risk() > 1.2f) {
                risk = "MDT (5/6)";
            } else if (props.risk() > 0.8f) {
                risk = "ENH (4/6)";
            } else if (props.risk() > 0.6f) {
                risk = "SLGT (3/6)";
            } else if (props.risk() > 0.3f) {
                risk = "MRGL (2/6)";
            } else if (props.risk() > 0.15f) {
                risk = "TSTM (1/6)";
            }
            String str = String.format(strForFormat, windAngle, (int)windspeed, (int)temperature, (int)dew, risk);
            player.sendSystemMessage((Component)Component.literal((String)str));
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }
}

