/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.block.entity;

import dev.protomanly.pmweather.block.entity.ModBlockEntities;
import dev.protomanly.pmweather.event.GameBusClientEvents;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandlerClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class RadarBlockEntity
extends BlockEntity {
    public List<Storm> storms = new ArrayList<Storm>();
    public int tickCount;
    public int updateCount;
    public SimplexNoise noise;
    public Map<String, Float> reflectivityMap = new HashMap<String, Float>();
    public Map<String, Float> velocityMap = new HashMap<String, Float>();
    public int lastUpdate = 0;

    public RadarBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.RADAR_BE.get(), pos, blockState);
        this.noise = new SimplexNoise((RandomSource)new LegacyRandomSource(0L));
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        ++this.tickCount;
        if (level.isClientSide() && (level.getGameTime() % 100L == 0L || this.storms.isEmpty())) {
            WeatherHandlerClient weatherHandler = (WeatherHandlerClient)GameBusClientEvents.weatherHandler;
            if (weatherHandler == null) {
                return;
            }
            ++this.updateCount;
            this.storms = weatherHandler.getStorms();
        }
    }
}

