/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.event;

import com.mojang.brigadier.CommandDispatcher;
import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.command.WeatherCommands;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.entity.ModEntities;
import dev.protomanly.pmweather.entity.MovingBlock;
import dev.protomanly.pmweather.util.Util;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WeatherHandlerServer;
import dev.protomanly.pmweather.weather.WeatherProperties;
import dev.protomanly.pmweather.weather.WindEngine;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.command.ConfigCommand;

@EventBusSubscriber(modid="pmweather", bus=EventBusSubscriber.Bus.GAME)
public class GameBusEvents {
    public static final Map<ResourceKey<Level>, WeatherHandler> MANAGERS = new Reference2ObjectOpenHashMap();
    public static final Map<String, WeatherHandler> MANAGERSLOOKUP = new HashMap<String, WeatherHandler>();

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (!level.isClientSide() && entity instanceof MovingBlock) {
            Vec3 wind = WindEngine.getWind(entity.getPosition(1.0f), level, false, true, false);
            entity.addDeltaMovement(wind.multiply((double)0.05f, 0.0, (double)0.05f).multiply((double)0.02f, 0.0, (double)0.02f));
        }
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!level.isClientSide() && ServerConfig.validDimensions != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (ServerConfig.validDimensions.contains(level.dimension())) {
                WeatherHandlerServer weatherHandler = (WeatherHandlerServer)MANAGERS.get(level.dimension());
                if (PMWeather.RANDOM.nextInt(2) == 0) {
                    ArrayList<ServerPlayer> validPlayers = new ArrayList<ServerPlayer>();
                    List plrs = serverLevel.players();
                    Collections.shuffle(plrs);
                    for (ServerPlayer player : plrs) {
                        boolean isTooNear = false;
                        for (ServerPlayer existing : validPlayers) {
                            if (!(existing.distanceTo((Entity)player) <= 64.0f)) continue;
                            isTooNear = true;
                            break;
                        }
                        if (isTooNear) continue;
                        validPlayers.add(player);
                    }
                    for (ServerPlayer player : validPlayers) {
                        for (int i = 0; i < 60; ++i) {
                            MovingBlock movingBlock;
                            BlockPos check = player.blockPosition().offset(new Vec3i(PMWeather.RANDOM.nextInt(-64, 65), 50, PMWeather.RANDOM.nextInt(-64, 65)));
                            float wind = (float)WindEngine.getWind(check = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, check).below(), level, false, true, false).length();
                            if (!(wind > 45.0f)) continue;
                            check = check.below(PMWeather.RANDOM.nextInt(3));
                            BlockState state = level.getBlockState(check);
                            Block block = state.getBlock();
                            float blockStrength = Storm.getBlockStrength(block, level);
                            if (ServerConfig.blockStrengths.containsKey(block)) {
                                blockStrength = ServerConfig.blockStrengths.get(block).floatValue();
                            }
                            blockStrength *= 0.9f;
                            boolean blacklisted = false;
                            for (TagKey<Block> tag : ServerConfig.blacklistedBlockTags) {
                                if (!block.defaultBlockState().is(tag)) continue;
                                blacklisted = true;
                                break;
                            }
                            if (blacklisted || ServerConfig.blacklistedBlocks.contains(block) || !Util.canWindAffect(check.getCenter(), level)) continue;
                            if (state.is(Tags.Blocks.GLASS_BLOCKS) || state.is(Tags.Blocks.GLASS_PANES)) {
                                double percChance = Math.clamp((wind - 55.0f) / 15.0f, 0.0f, 1.0f);
                                if (!((double)PMWeather.RANDOM.nextFloat() <= percChance) || !Util.canWindAffect(check.getCenter(), level)) continue;
                                level.removeBlock(check, false);
                                level.playSound(null, check, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, PMWeather.RANDOM.nextFloat(0.8f, 1.2f));
                                continue;
                            }
                            double percChance = Math.clamp(Math.pow(Math.clamp(Math.max((double)(wind - blockStrength), 0.0) / 20.0, 0.0, 1.0), 2.0) + 0.02, 0.0, 1.0);
                            if (wind < blockStrength) {
                                percChance = 0.0;
                            }
                            if (block.defaultDestroyTime() < 0.05f && block.defaultDestroyTime() >= 0.0f && (double)PMWeather.RANDOM.nextFloat() <= percChance && Util.canWindAffect(check.getCenter(), level)) {
                                level.removeBlock(check, false);
                                continue;
                            }
                            if (!((double)PMWeather.RANDOM.nextFloat() <= percChance) || !Util.canWindAffect(check.getCenter(), level) || (movingBlock = (MovingBlock)ModEntities.MOVING_BLOCK.get().create(level)) == null) continue;
                            movingBlock.setStartPos(check);
                            movingBlock.setBlockState(state);
                            movingBlock.setPos(check.getX(), check.getY(), check.getZ());
                            level.removeBlock(check, false);
                            if (level.isLoaded(check)) {
                                level.addFreshEntity((Entity)movingBlock);
                                continue;
                            }
                            movingBlock.discard();
                        }
                    }
                }
                int storms = 0;
                int clouds = 0;
                for (Storm storm : weatherHandler.getStorms()) {
                    if (storm.visualOnly) {
                        ++clouds;
                        continue;
                    }
                    ++storms;
                }
                if (storms > ServerConfig.maxStorms) {
                    PMWeather.LOGGER.warn("Hit storm limit! Couldn't check for new storm spawns.");
                }
                if (weatherHandler != null && level.getGameTime() % 1200L == 0L) {
                    PMWeather.LOGGER.debug("Checking for storm/cloud spawns");
                    ArrayList<ServerPlayer> validPlayers = new ArrayList<ServerPlayer>();
                    List plrs = serverLevel.players();
                    Collections.shuffle(plrs);
                    for (ServerPlayer player : plrs) {
                        boolean isTooNear = false;
                        for (ServerPlayer existing : validPlayers) {
                            if (!(existing.distanceTo((Entity)player) <= (float)ServerConfig.spawnRange / 2.0f)) continue;
                            isTooNear = true;
                            break;
                        }
                        if (isTooNear) continue;
                        validPlayers.add(player);
                    }
                    PMWeather.LOGGER.debug("{} players available to spawn around", (Object)validPlayers.size());
                    for (ServerPlayer player : validPlayers) {
                        boolean squall;
                        Vec3 pos = new Vec3(player.getX(), (double)level.getMaxBuildHeight(), player.getZ()).add((double)PMWeather.RANDOM.nextInt(-ServerConfig.spawnRange, ServerConfig.spawnRange + 1), 0.0, (double)PMWeather.RANDOM.nextInt(-ServerConfig.spawnRange, ServerConfig.spawnRange + 1));
                        Vec3 wind = WindEngine.getWind(new Vec3(player.getX(), 256.0, player.getZ()), level, true, true, false);
                        boolean bl = squall = PMWeather.RANDOM.nextInt(ServerConfig.chanceInOneSquall) == 0;
                        if (squall) {
                            PMWeather.LOGGER.debug("Checking for squall spawn");
                            dist = PMWeather.RANDOM.nextFloat(256.0f, 512.0f) * 6.0f;
                            pos = pos.add(wind.normalize().multiply((double)(-dist), 0.0, (double)(-dist)));
                        } else {
                            dist = PMWeather.RANDOM.nextFloat(256.0f, 512.0f) * 4.0f;
                            pos = pos.add(wind.normalize().multiply((double)(-dist), 0.0, (double)(-dist)));
                        }
                        PMWeather.LOGGER.debug("Checking storm spawns around {} at {}, {}", new Object[]{player.getDisplayName().getString(), (int)pos.x, (int)pos.z});
                        double spawnChance = ServerConfig.stormSpawnChancePerMinute;
                        WeatherProperties.Properties props = WeatherProperties.getTemperature((WeatherHandler)weatherHandler, level, serverLevel.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, new BlockPos((int)pos.x, (int)pos.y, (int)pos.z)));
                        if (ServerConfig.environmentSystem) {
                            PMWeather.LOGGER.debug("W/ spawn chance: {}%\nRisk: {}", (Object)((int)((spawnChance *= (double)(props.risk() * 1.25f)) * 100.0)), (Object)((int)(props.risk() * 100.0f)));
                        }
                        if ((double)PMWeather.RANDOM.nextFloat() <= spawnChance && storms < ServerConfig.maxStorms) {
                            if (squall) {
                                storm = new Storm(weatherHandler, level, props, 1);
                                storm.width = 0.0f;
                                storm.windspeed = 0;
                                storm.stormType = 1;
                                storm.stage = 0;
                                if (ServerConfig.environmentSystem) {
                                    if (PMWeather.RANDOM.nextFloat() <= props.risk() * 2.5f) {
                                        storm.maxStage = Math.max(storm.maxStage, 1);
                                    }
                                    if (PMWeather.RANDOM.nextFloat() <= props.risk() * 1.75f) {
                                        storm.maxStage = Math.max(storm.maxStage, 2);
                                    }
                                    if (PMWeather.RANDOM.nextFloat() <= props.risk()) {
                                        storm.maxStage = Math.max(storm.maxStage, 3);
                                    }
                                    storm.recalc(props);
                                }
                                if (wind.length() < 10.0) {
                                    wind = wind.normalize().multiply(10.0, 0.0, 10.0);
                                }
                                storm.position = pos;
                                storm.velocity = wind.multiply(0.1, 0.0, 0.1);
                                storm.energy = 0;
                                storm.initFirstTime();
                                weatherHandler.addStorm(storm);
                                weatherHandler.syncStormNew(storm);
                            } else {
                                storm = new Storm(weatherHandler, level, props, 0);
                                storm.width = 0.0f;
                                storm.windspeed = 0;
                                storm.stormType = 0;
                                storm.stage = 0;
                                if (ServerConfig.environmentSystem) {
                                    if (PMWeather.RANDOM.nextFloat() <= props.risk() * 1.5f) {
                                        storm.maxStage = Math.max(storm.maxStage, 1);
                                    }
                                    if (PMWeather.RANDOM.nextFloat() <= props.risk() * 0.75f) {
                                        storm.maxStage = Math.max(storm.maxStage, 2);
                                    }
                                    if (PMWeather.RANDOM.nextFloat() <= props.risk() * 0.35f) {
                                        storm.maxStage = Math.max(storm.maxStage, 3);
                                    }
                                    storm.recalc(props);
                                }
                                storm.position = pos;
                                storm.velocity = Vec3.ZERO;
                                storm.energy = 0;
                                storm.initFirstTime();
                                weatherHandler.addStorm(storm);
                                weatherHandler.syncStormNew(storm);
                            }
                            PMWeather.LOGGER.debug("Spawned storm at {}, {}", (Object)((int)pos.x), (Object)((int)pos.z));
                            continue;
                        }
                        PMWeather.LOGGER.debug("Storm spawn failed, rolled bad number or too many storms");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceKey dimension = serverLevel.dimension();
            WeatherHandlerServer weatherHandler = new WeatherHandlerServer(serverLevel);
            weatherHandler.read();
            MANAGERS.put((ResourceKey<Level>)dimension, weatherHandler);
            MANAGERSLOOKUP.put(dimension.location().toString(), weatherHandler);
            if (WindEngine.simplexNoise == null) {
                WindEngine.init(weatherHandler);
            }
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MANAGERS.remove(serverLevel.dimension());
            MANAGERSLOOKUP.remove(serverLevel.dimension().toString());
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        if (!event.getServer().isPaused()) {
            for (WeatherHandler weatherHandler : MANAGERS.values()) {
                weatherHandler.tick();
            }
        }
    }

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        new WeatherCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    public static void playerRequestsFullSync(ServerPlayer player) {
        WeatherHandler weatherHandler = MANAGERS.get(player.level().dimension());
        if (weatherHandler instanceof WeatherHandlerServer) {
            WeatherHandlerServer weatherHandlerServer = (WeatherHandlerServer)weatherHandler;
            weatherHandlerServer.playerJoinedWorldSyncFull(player);
        }
    }
}

