/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.mixin;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.event.GameBusEvents;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WeatherProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class ServerLevelMixin {
    public boolean shouldFreeze(ServerLevel level, BlockPos water, boolean mustBeAtEdge) {
        if (water.getY() >= level.getMinBuildHeight() && water.getY() < level.getMaxBuildHeight() && level.getBrightness(LightLayer.BLOCK, water) < 10) {
            BlockState blockstate = level.getBlockState(water);
            FluidState fluidstate = level.getFluidState(water);
            if (fluidstate.getType() == Fluids.WATER && blockstate.getBlock() instanceof LiquidBlock) {
                boolean flag;
                if (!mustBeAtEdge) {
                    return true;
                }
                boolean bl = flag = level.isWaterAt(water.west()) && level.isWaterAt(water.east()) && level.isWaterAt(water.north()) && level.isWaterAt(water.south());
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean shouldSnow(ServerLevel level, BlockPos pos) {
        BlockState blockstate;
        return pos.getY() >= level.getMinBuildHeight() && pos.getY() < level.getMaxBuildHeight() && ((blockstate = level.getBlockState(pos)).isAir() || blockstate.is(Blocks.SNOW)) && Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)level, pos);
    }

    @Inject(method={"tickPrecipitation"}, at={@At(value="HEAD")}, cancellable=true)
    public void editTickPrecipitation(BlockPos blockPos, CallbackInfo callbackInfo) {
        ServerLevel level = (ServerLevel)this;
        BlockPos blockpos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos);
        BlockPos blockpos1 = blockpos.below();
        WeatherHandler weatherHandler = GameBusEvents.MANAGERS.get(level.dimension());
        WeatherProperties.Properties props = WeatherProperties.getTemperature(weatherHandler, (Level)level, blockpos.getCenter());
        float rain = weatherHandler.getPrecipitation(blockpos.getCenter());
        if (level.isAreaLoaded(blockpos1, 1) && props.temperature() <= 0.0f && this.shouldFreeze(level, blockpos1, true)) {
            level.setBlockAndUpdate(blockpos1, Blocks.ICE.defaultBlockState());
        }
        BlockState blockstate = level.getBlockState(blockpos);
        int c = 20;
        if (props.temperature() > 2.0f) {
            c = 10;
        }
        if (props.temperature() > 4.0f) {
            c = 4;
        }
        if (props.temperature() > 6.0f) {
            c = 1;
        }
        if (blockstate.is(Blocks.SNOW) && props.temperature() > 0.0f && PMWeather.RANDOM.nextInt(c) == 0) {
            int j = (Integer)blockstate.getValue((Property)SnowLayerBlock.LAYERS);
            if (j > 1) {
                BlockState blockstate1 = (BlockState)blockstate.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(j - 1));
                Block.pushEntitiesUp((BlockState)blockstate, (BlockState)blockstate1, (LevelAccessor)level, (BlockPos)blockpos);
                level.setBlockAndUpdate(blockpos, blockstate1);
            } else {
                level.removeBlock(blockpos, false);
            }
        }
        if (rain > 0.2f) {
            int i = ServerConfig.snowAccumulationHeight;
            if (i > 0 && props.temperature() <= 0.0f && this.shouldSnow(level, blockpos)) {
                BlockState blockstateW = level.getBlockState(blockpos);
                if (blockstateW.is(Blocks.SNOW)) {
                    int j = (Integer)blockstateW.getValue((Property)SnowLayerBlock.LAYERS);
                    if (j < Math.min(i, 8)) {
                        BlockState blockstate1 = (BlockState)blockstateW.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(j + 1));
                        Block.pushEntitiesUp((BlockState)blockstateW, (BlockState)blockstate1, (LevelAccessor)level, (BlockPos)blockpos);
                        level.setBlockAndUpdate(blockpos, blockstate1);
                    }
                } else {
                    level.setBlockAndUpdate(blockpos, Blocks.SNOW.defaultBlockState());
                }
            }
            Biome.Precipitation biome$precipitation = Biome.Precipitation.NONE;
            if (rain > 0.2f) {
                biome$precipitation = Biome.Precipitation.RAIN;
                if (props.temperature() <= 0.0f) {
                    biome$precipitation = Biome.Precipitation.SNOW;
                }
            }
            if (biome$precipitation != Biome.Precipitation.NONE) {
                BlockState blockstate2 = level.getBlockState(blockpos1);
                blockstate2.getBlock().handlePrecipitation(blockstate2, (Level)level, blockpos1, biome$precipitation);
            }
        }
        callbackInfo.cancel();
    }
}

