/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.networking;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.event.GameBusClientEvents;
import dev.protomanly.pmweather.weather.WeatherHandlerClient;
import dev.protomanly.pmweather.weather.WindEngine;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public record PacketNBTFromServer(CompoundTag compoundTag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketNBTFromServer> TYPE = new CustomPacketPayload.Type(PMWeather.getPath("nbt_client"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketNBTFromServer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, PacketNBTFromServer::compoundTag, PacketNBTFromServer::new);

    public PacketNBTFromServer(RegistryFriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.compoundTag);
    }

    public void handle(Player player) {
        try {
            String packetCommand = this.compoundTag.getString("packetCommand");
            String command = this.compoundTag.getString("command");
            GameBusClientEvents.getClientWeather();
            WeatherHandlerClient weatherHandler = (WeatherHandlerClient)GameBusClientEvents.weatherHandler;
            if (packetCommand.equals("WeatherData")) {
                weatherHandler.nbtSyncFromServer(this.compoundTag);
            } else if (packetCommand.equals("LevelData") && command.equals("syncMisc")) {
                weatherHandler.seed = this.compoundTag.getLong("seed");
                WindEngine.init(weatherHandler);
            }
        }
        catch (Exception e) {
            PMWeather.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

